/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.FolderVersioningApi;
import com.xebialabs.xlrelease.api.v1.form.CreateVersionForm;
import com.xebialabs.xlrelease.api.v1.views.VersionInfo;
import com.xebialabs.xlrelease.api.v1.views.VersionsView;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.versioning.ascode.FoldersWithAppliedVersionInfo;
import com.xebialabs.xlrelease.domain.versioning.ascode.GitBranch;
import com.xebialabs.xlrelease.domain.versioning.ascode.VersioningStyle;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReport;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import java.util.Date;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t5f\u0001\u0002\u0014(\u0001QB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u00111\u0004!\u0011!Q\u0001\n5DQ\u0001\u001d\u0001\u0005\u0002EDQa\u001f\u0001\u0005BqDaa\u001f\u0001\u0005B\u0005=\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\tI\u0006\u0001C!\u0003kBq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002\u0018\u0002!\t%!'\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\t9\u000f\u0001C!\u0003SDq!a=\u0001\t\u0003\n)\u0010C\u0004\u0003\u0004\u0001!\tE!\u0002\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u000e!9!\u0011\u0003\u0001\u0005B\tM\u0001b\u0002B\r\u0001\u0011\u0005#1\u0004\u0005\b\u0005?\u0001A\u0011\tB\u0011\u0011\u001d\u0011)\u0003\u0001C!\u0005OAqAa\f\u0001\t\u0003\u0012\t\u0004C\u0004\u0003@\u0001!\tE!\u0011\t\u000f\t-\u0003\u0001\"\u0011\u0003N!9!\u0011\u000b\u0001\u0005B\tM\u0003b\u0002B/\u0001\u0011\u0005#q\f\u0005\b\u0005_\u0002A\u0011\tB9\u0011\u001d\u0011I\b\u0001C!\u0005wBqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003\f\u0002!IA!$\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\n9bi\u001c7eKJ4VM]:j_:LgnZ!qS&k\u0007\u000f\u001c\u0006\u0003Q%\nA![7qY*\u0011!fK\u0001\u0003mFR!\u0001L\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002/_\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003aE\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003I\n1aY8n\u0007\u0001\u00192\u0001A\u001b>!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003mC:<'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003y]\u0012aa\u00142kK\u000e$\bC\u0001 @\u001b\u0005I\u0013B\u0001!*\u0005M1u\u000e\u001c3feZ+'o]5p]&tw-\u00119j\u0003E\u0001XM]7jgNLwN\\\"iK\u000e\\WM\u001d\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b6\n\u0001b]3dkJLG/_\u0005\u0003\u000f\u0012\u0013\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0003]1w\u000e\u001c3feZ+'o]5p]&twmU3sm&\u001cW\r\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006\u00191oY7\u000b\u00059{\u0015AB1tG>$WM\u0003\u0002Q[\u0005Qa/\u001a:tS>t\u0017N\\4\n\u0005I[%a\u0006$pY\u0012,'OV3sg&|g.\u001b8h'\u0016\u0014h/[2f\u00039\u0001(/\u001a<jK^\u001cVM\u001d<jG\u0016\u0004\"AS+\n\u0005Y[%A\b$pY\u0012,'OV3sg&|g.\u001b8h!J,g/[3x'\u0016\u0014h/[2f\u0003q1w\u000e\u001c3feZ+'o]5p]&tw-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"!\u0017/\u000e\u0003iS!aW'\u0002\r\u0005\u001cGo\u001c:t\u0013\ti&L\u0001\u000fG_2$WM\u001d,feNLwN\\5oO\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002/Y,'o]5p]&twm\u0015;zY\u0016\u0014Vm]8mm\u0016\u0014\bC\u00011d\u001b\u0005\t'B\u00012L\u0003!\u0019HO]1uK\u001eL\u0018B\u00013b\u0005i1VM]:j_:LgnZ*ue\u0006$XmZ=SKN|GN^3s\u0003Q\u0019wN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKB\u0011qM[\u0007\u0002Q*\u0011\u0011.L\u0001\bg\u0016\u0014h/[2f\u0013\tY\u0007N\u0001\u000bD_:4\u0017nZ;sCRLwN\\*feZL7-Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005\u001dt\u0017BA8i\u000551u\u000e\u001c3feN+'O^5dK\u00061A(\u001b8jiz\"\u0002B\u001d;vm^D\u0018P\u001f\t\u0003g\u0002i\u0011a\n\u0005\u0006\u0003\"\u0001\rA\u0011\u0005\u0006\u0011\"\u0001\r!\u0013\u0005\u0006'\"\u0001\r\u0001\u0016\u0005\u0006/\"\u0001\r\u0001\u0017\u0005\u0006=\"\u0001\ra\u0018\u0005\u0006K\"\u0001\rA\u001a\u0005\u0006Y\"\u0001\r!\\\u0001\fO\u0016$h+\u001a:tS>t7\u000fF\u0003~\u0003\u000f\t)\u0003E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003I\u0013!\u0002<jK^\u001c\u0018bAA\u0003\u007f\naa+\u001a:tS>t7OV5fo\"9\u0011\u0011B\u0005A\u0002\u0005-\u0011\u0001\u00034pY\u0012,'/\u00133\u0011\t\u00055\u0011q\u0004\b\u0005\u0003\u001f\tY\u0002\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bM\u0001\u0007yI|w\u000e\u001e \u000b\u0005\u0005e\u0011!B:dC2\f\u0017\u0002BA\u000f\u0003/\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'\u0002BA\u000f\u0003/Aq!a\n\n\u0001\u0004\tI#\u0001\u0007gKR\u001c\u0007n\u00115b]\u001e,7\u000fE\u00027\u0003WI1!!\f8\u0005\u001d\u0011un\u001c7fC:$2!`A\u0019\u0011\u001d\tIA\u0003a\u0001\u0003\u0017\tabZ3u\u00032d'I]1oG\",7\u000f\u0006\u0004\u00028\u0005M\u0013Q\u000b\t\u0007\u0003s\ty$a\u0011\u000e\u0005\u0005m\"bAA\u001fs\u0005!Q\u000f^5m\u0013\u0011\t\t%a\u000f\u0003\t1K7\u000f\u001e\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)\u0019a*!\u0013\u000b\u0007A\u000bYEC\u0002\u0002N5\na\u0001Z8nC&t\u0017\u0002BA)\u0003\u000f\u0012\u0011bR5u\u0005J\fgn\u00195\t\u000f\u0005%1\u00021\u0001\u0002\f!9\u0011qK\u0006A\u0002\u0005-\u0011\u0001C2p]\u001aLw-\u00133\u0002\u001b\r\u0014X-\u0019;f-\u0016\u00148/[8o)\u0019\ti&a\u0019\u0002fA\u0019a0a\u0018\n\u0007\u0005\u0005tPA\u0006WKJ\u001c\u0018n\u001c8J]\u001a|\u0007bBA\u0005\u0019\u0001\u0007\u00111\u0002\u0005\b\u0003Ob\u0001\u0019AA5\u0003-1XM]:j_:4uN]7\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001c*\u0003\u00111wN]7\n\t\u0005M\u0014Q\u000e\u0002\u0012\u0007J,\u0017\r^3WKJ\u001c\u0018n\u001c8G_JlG\u0003CA/\u0003o\nI(! \t\u000f\u0005%Q\u00021\u0001\u0002\f!9\u00111P\u0007A\u0002\u0005-\u0011a\u0003<feNLwN\u001c(b[\u0016Dq!a \u000e\u0001\u0004\tY!A\u0006eKN\u001c'/\u001b9uS>t\u0017\u0001D1qa2Lh+\u001a:tS>tGCBAC\u0003#\u000b\u0019\n\u0005\u0003\u0002\b\u00065UBAAE\u0015\u0011\tY)a\u0012\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0003\u0002\u0010\u0006%%\u0001\u0005,bY&$\u0017\r^5p]J+\u0007o\u001c:u\u0011\u001d\tIA\u0004a\u0001\u0003\u0017Aq!!&\u000f\u0001\u0004\tY!A\u0004wKJ\u001c\u0018n\u001c8\u0002\u001dA\u0014XM^5fo\u000e+(O]3oiR1\u00111BAN\u0003;Cq!!\u0003\u0010\u0001\u0004\tY\u0001C\u0004\u0002 >\u0001\r!a\u0003\u0002\u0011\u0019LG.\u001a8b[\u0016\fa\u0002\u001d:fm&,wOV3sg&|g\u000e\u0006\u0005\u0002\f\u0005\u0015\u0016qUAU\u0011\u001d\tI\u0001\u0005a\u0001\u0003\u0017Aq!!&\u0011\u0001\u0004\tY\u0001C\u0004\u0002 B\u0001\r!a\u0003\u0002+\u001d,GOV3sg&|g.\u001a3GS2,g*Y7fgR1\u0011qVAY\u0003g\u0003b!!\u000f\u0002@\u0005-\u0001bBA\u0005#\u0001\u0007\u00111\u0002\u0005\b\u0003+\u000b\u0002\u0019AA\u0006\u0003y9W\r^\"veJ,g\u000e\u001e,feNLwN\\1cY\u00164\u0015\u000e\\3OC6,7\u000f\u0006\u0003\u00020\u0006e\u0006bBA\u0005%\u0001\u0007\u00111B\u0001\fO\u0016$8+\u001a;uS:<7\u000f\u0006\u0003\u0002@\u0006-\u0007\u0003BAa\u0003\u000fl!!a1\u000b\t\u0005\u0015\u0017qI\u0001\tg\u0016$H/\u001b8hg&!\u0011\u0011ZAb\u0005a1u\u000e\u001c3feZ+'o]5p]&twmU3ui&twm\u001d\u0005\b\u0003\u0013\u0019\u0002\u0019AA\u0006Q!\tY-a4\u0002d\u0006\u0015\b\u0003BAi\u0003?l!!a5\u000b\t\u0005U\u0017q[\u0001\u0003eNTA!!7\u0002\\\u0006\u0011qo\u001d\u0006\u0003\u0003;\fqA[1lCJ$\u0018-\u0003\u0003\u0002b\u0006M'!\u0003)bi\"\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\t\tI!\u0001\bva\u0012\fG/Z*fiRLgnZ:\u0015\r\u0005}\u00161^Ax\u0011\u001d\tI\u0001\u0006a\u0001\u0003\u0017A\u0003\"a;\u0002P\u0006\r\u0018Q\u001d\u0005\b\u0003c$\u0002\u0019AA`\u0003\u0019\u0019wN\u001c4jO\u0006qA-\u001a7fi\u0016\u001cV\r\u001e;j]\u001e\u001cH\u0003BA|\u0003\u007f\u0004B!!?\u0002|6\u0011\u0011qC\u0005\u0005\u0003{\f9B\u0001\u0003V]&$\bbBA\u0005+\u0001\u0007\u00111\u0002\u0015\t\u0003\u007f\fy-a9\u0002f\u0006yA-\u001a7fi\u0016dunY1m%\u0016\u0004x\u000e\u0006\u0004\u0002x\n\u001d!\u0011\u0002\u0005\b\u0003\u00131\u0002\u0019AA\u0006\u0011\u001d\u0011YA\u0006a\u0001\u0003S\t1b\u00197vgR,'oV5eKR!\u0011q\u001fB\b\u0011\u001d\tIa\u0006a\u0001\u0003\u0017\taB]3tKRdunY1m%\u0016\u0004x\u000e\u0006\u0004\u0002x\nU!q\u0003\u0005\b\u0003\u0013A\u0002\u0019AA\u0006\u0011\u001d\u0011Y\u0001\u0007a\u0001\u0003S\tqB^1mS\u0012\fG/Z\"veJ,g\u000e\u001e\u000b\u0005\u0003\u000b\u0013i\u0002C\u0004\u0002\ne\u0001\r!a\u0003\u0002+\u001d,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4fgR!\u0011Q\u0011B\u0012\u0011\u001d\tIA\u0007a\u0001\u0003\u0017\tQc]3u-\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,7\u000f\u0006\u0004\u0002x\n%\"1\u0006\u0005\b\u0003\u0013Y\u0002\u0019AA\u0006\u0011\u001d\u0011ic\u0007a\u0001\u0003\u000b\u000b\u0001C^1mS\u0012\fG/[8o%\u0016\u0004xN\u001d;\u0002)\u001d,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4f)\u0019\u0011\u0019D!\u000f\u0003<A!\u0011q\u0011B\u001b\u0013\u0011\u00119$!#\u0003/Y\u000bG.\u001b3bi&|gNU3q_J$X*Z:tC\u001e,\u0007bBA\u00059\u0001\u0007\u00111\u0002\u0005\b\u0005{a\u0002\u0019AA\u0006\u0003%iWm]:bO\u0016LE-A\u000etKR4\u0016\r\\5eCRLwN\\'fgN\fw-Z:Ti\u0006$Xo\u001d\u000b\t\u0003o\u0014\u0019E!\u0012\u0003H!9\u0011\u0011B\u000fA\u0002\u0005-\u0001b\u0002B\u001f;\u0001\u0007\u00111\u0002\u0005\b\u0005\u0013j\u0002\u0019\u0001B\u001a\u0003E1\u0018\r\\5eCRLwN\\'fgN\fw-Z\u0001\rG2,\u0017M]*fGJ,Go\u001d\u000b\u0005\u0003o\u0014y\u0005C\u0004\u0002\ny\u0001\r!a\u0003\u0002'\u001d,GOV3sg&|g.\u001b8h'RLH.Z:\u0015\u0005\tU\u0003CBA\u001d\u0003\u007f\u00119\u0006\u0005\u0003\u0002F\te\u0013\u0002\u0002B.\u0003\u000f\u0012qBV3sg&|g.\u001b8h'RLH.Z\u0001\u0010G>l\u0007/\u0019:f-\u0016\u00148/[8ogRQ\u00111\u0002B1\u0005G\u00129Ga\u001b\t\u000f\u0005%\u0001\u00051\u0001\u0002\f!9!Q\r\u0011A\u0002\u0005-\u0011\u0001\u00034jY\u0016t\u0015-\\3\t\u000f\t%\u0004\u00051\u0001\u0002\f\u0005YA.\u001a4u-\u0016\u00148/[8o\u0011\u001d\u0011i\u0007\ta\u0001\u0003\u0017\tAB]5hQR4VM]:j_:\f\u0011cY8na\u0006\u0014XmV5uQ2\u000bG/Z:u)!\tYAa\u001d\u0003v\t]\u0004bBA\u0005C\u0001\u0007\u00111\u0002\u0005\b\u0005K\n\u0003\u0019AA\u0006\u0011\u001d\t)*\ta\u0001\u0003\u0017\tacZ3u-\u0016\u00148/[8oK\u00124u\u000e\u001c3fe&sgm\u001c\u000b\u0003\u0005{\u0002b!!\u000f\u0002@\t}\u0004\u0003BA#\u0005\u0003KAAa!\u0002H\tibi\u001c7eKJ\u001cx+\u001b;i\u0003B\u0004H.[3e-\u0016\u00148/[8o\u0013:4w.\u0001\u0011wC2LG-\u0019;f\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cV\r\u001e;j]\u001e\u001cH\u0003BA|\u0005\u0013Cq!!=$\u0001\u0004\ty,A\fwC2LG-\u0019;f-\u0016\u00148/[8oS:<7\u000b^=mKR!\u0011q\u001fBH\u0011\u001d\t\t\u0010\na\u0001\u0003\u007f\u000bQC^1mS\u0012\fG/Z$ji\u000e{gN\\3di&|g\u000e\u0006\u0003\u0002x\nU\u0005bBAyK\u0001\u0007\u0011q\u0018\u0015\u0004\u0001\te\u0005\u0003\u0002BN\u0005Sk!A!(\u000b\t\t}%\u0011U\u0001\u000bgR,'/Z8usB,'\u0002\u0002BR\u0005K\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0005O\u000b1a\u001c:h\u0013\u0011\u0011YK!(\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class FolderVersioningApiImpl
implements FolderVersioningApi {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final ConfigurationService configurationService;
    private final FolderService folderService;

    public String serviceName() {
        return super.serviceName();
    }

    public VersionsView getVersions(String folderId, Boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = Predef$.MODULE$.Boolean2boolean(fetchChanges) ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    public VersionsView getVersions(String folderId) {
        return this.getVersions(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public java.util.List<GitBranch> getAllBranches(String folderId, String configId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getAllBranches(configId)).asJava();
    }

    public VersionInfo createVersion(String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)versionForm.getName()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (String)"Version name must be provided.", (Object[])new Object[0]);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.getName(), (String)Option$.MODULE$.apply((Object)versionForm.getDescription()).getOrElse((Function0 & Serializable)() -> ""));
    }

    public VersionInfo createVersion(String folderId, String versionName, String description) {
        CreateVersionForm createVersionForm = new CreateVersionForm();
        createVersionForm.setName(versionName);
        createVersionForm.setDescription(description);
        return this.createVersion(folderId, createVersionForm);
    }

    public ValidationReport applyVersion(String folderId, String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        return this.folderVersioningService.applyVersion(folderId, version);
    }

    public String previewCurrent(String folderId, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, (String)Option$.MODULE$.apply((Object)filename).getOrElse((Function0 & Serializable)() -> ""));
    }

    public String previewVersion(String folderId, String version, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    public java.util.List<String> getVersionedFileNames(String folderId, String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionedFileNames(folderId, version)).asJava();
    }

    public java.util.List<String> getCurrentVersionableFileNames(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionableFileNames(folderId)).asJava();
    }

    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        FolderVersioningSettings folderVersioningSettings;
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.validateFolderVersioningSettings(config);
        config.setFolderId(folderId);
        try {
            folderVersioningSettings = this.folderVersioningActorService.createOrUpdateSettings(config);
        }
        catch (ScmException e) {
            throw new IllegalArgumentException("Unable to update folder versioning settings: " + e.getMessage(), e);
        }
        return folderVersioningSettings;
    }

    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.folderService.exists(folderId), (String)("Folder '" + folderId + "' does not exist in the repository."), (Object[])new Object[0]);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    public void deleteLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public void deleteLocalRepo(String folderId) {
        this.deleteLocalRepo(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public void resetLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public ValidationReport validateCurrent(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    public ValidationReport getValidationMessages(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    public void setValidationMessages(String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.getWarnings()).asScala().toSeq());
    }

    public ValidationReportMessage getValidationMessage(String folderId, String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (ValidationReportMessage)Option$.MODULE$.apply((Object)this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Validation message with id " + messageId + " not found");
        });
    }

    public void setValidationMessagesStatus(String folderId, String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    public void clearSecrets(String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    public java.util.List<VersioningStyle> getVersioningStyles() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersioningStyles()).asJava();
    }

    public String compareVersions(String folderId, String fileName, String leftVersion, String rightVersion) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Checks.checkArgument((fileName != null && !fileName.isEmpty() ? 1 : 0) != 0, (String)"File name must be provided for comparison.", (Object[])new Object[0]);
        return this.folderVersioningService.compareVersions(folderId, fileName, leftVersion, rightVersion);
    }

    public String compareWithLatest(String folderId, String fileName, String version) {
        return this.compareVersions(folderId, fileName, null, version);
    }

    public java.util.List<FoldersWithAppliedVersionInfo> getVersionedFolderInfo() {
        return this.folderVersioningService.getVersionedFolderInfo();
    }

    private void validateFolderVersioningSettings(FolderVersioningSettings config) {
        this.validateVersioningStyle(config);
        this.validateGitConnection(config);
    }

    private void validateVersioningStyle(FolderVersioningSettings config) {
        Option styleInput = Option$.MODULE$.apply((Object)config.getVersioningStyle()).map((Function1 & Serializable)x$3 -> x$3.trim());
        boolean bl = false;
        Some some = null;
        Option option = styleInput;
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String style = (String)some.value();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(style))) {
                List<VersioningStyle> supported = this.versioningStyleResolver.supportedStyles();
                String canonical = (String)supported.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningApiImpl.$anonfun$validateVersioningStyle$2(style, s))).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> {
                    String allowed = supported.map((Function1 & Serializable)x$5 -> x$5.id()).mkString(", ");
                    throw new IllegalArgumentException("Invalid versioningStyle '" + style + "'. Supported versioning styles: " + allowed);
                });
                config.setVersioningStyle(canonical);
                return;
            }
        }
        if (bl) {
            String allowed = this.versioningStyleResolver.supportedStyles().map((Function1 & Serializable)x$6 -> x$6.id()).mkString(", ");
            throw new IllegalArgumentException("Missing versioningStyle. Supported versioning styles: " + allowed);
        }
        throw new MatchError((Object)option);
    }

    private void validateGitConnection(FolderVersioningSettings config) {
        boolean gitConnectionValid = Option$.MODULE$.apply((Object)config.getGitConnection()).exists((Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)this.configurationService.exists(conn.getId())));
        Checks.checkArgument((boolean)gitConnectionValid, (String)"A valid gitConnection must be specified.", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$validateVersioningStyle$2(String style$1, VersioningStyle s) {
        return s.id().equalsIgnoreCase(style$1);
    }

    public FolderVersioningApiImpl(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService, VersioningStrategyResolver versioningStyleResolver, ConfigurationService configurationService, FolderService folderService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.configurationService = configurationService;
        this.folderService = folderService;
    }
}

