/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardCreatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardDeletedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardUpdatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecoratorCache;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0010!\u00015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\u0005\u0004!Q1A\u0005\u0002\tD\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tU\u0002\u0011)\u0019!C\u0002W\"A\u0011\u000f\u0001B\u0001B\u0003%A\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!I\u0011Q\u000f\u0001\u0012\u0002\u0013\u0005\u0011q\u000f\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a'\u0001\t\u0003\ti\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBAp\u0001\u0011E\u0011\u0011\u001d\u0005\b\u0003O\u0004A\u0011BAu\u0011\u001d\ti\u000f\u0001C\u0005\u0003_Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!1\u0007\u0001\u0005\n\tU\u0002b\u0002B\u001d\u0001\u0011%!1\b\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\u0012\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005\u0005\u0012\u0013aB:feZL7-\u001a\u0006\u0003G\u0011\n\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u00152\u0013a\u00029mk\u001eLgn\u001d\u0006\u0003O!\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%R\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0013aA2p[\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u0006\u0019B-Y:iE>\f'\u000f\u001a*fa>\u001c\u0018\u000e^8ssB\u0011a'O\u0007\u0002o)\u0011\u0001HI\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001e8\u0005u!U\r\\3hCRLgn\u001a#bg\"\u0014w.\u0019:e%\u0016\u0004xn]5u_JL\u0018!\u00053bg\"\u0014w.\u0019:e'\u0016\u001cWO]5usB\u0011QHP\u0007\u0002A%\u0011q\b\t\u0002\u0012\t\u0006\u001c\bNY8be\u0012\u001cVmY;sSRL\u0018A\u00073bg\"\u0014w.\u0019:e'\u0016\u001cWO]5us\u0012+7m\u001c:bi>\u0014\bCA\u001fC\u0013\t\u0019\u0005E\u0001\u000eECND'm\\1sIN+7-\u001e:jif$UmY8sCR|'/\u0001\u0007dC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006)1-Y2iK*\u0011!jS\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA*A\u0002pe\u001eL!AT$\u0003\u0019\r\u000b7\r[3NC:\fw-\u001a:\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b\u0001b]3dkJLG/\u001f\u0006\u0003+\"\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003/J\u00131BU8mKN+'O^5dK\u0006i1o\u0019:jaR\u001cVM\u001d<jG\u0016\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\r)LH\u000f[8o\u0015\tqf%\u0001\u0004tGJL\u0007\u000f^\u0005\u0003An\u00131CS=uQ>t7k\u0019:jaR\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011aMJ\u0001\u0007KZ,g\u000e^:\n\u0005!,'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\fG&LEmU3sm&\u001cW-F\u0001m!\tiw.D\u0001o\u0015\t\tc%\u0003\u0002q]\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}QIA/\u001e<xqfT8\u0010 \t\u0003{\u0001AQ\u0001N\u0006A\u0002UBQaO\u0006A\u0002qBQ\u0001Q\u0006A\u0002\u0005CQ\u0001R\u0006A\u0002\u0015CQaT\u0006A\u0002ACQ\u0001W\u0006A\u0002eCQ!Y\u0006A\u0002\rDQA[\u0006A\u00041D#a\u0003@\u0011\u0007}\fi!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u000f\tI!A\u0004gC\u000e$xN]=\u000b\u0007\u0005-\u0011*A\u0003cK\u0006t7/\u0003\u0003\u0002\u0010\u0005\u0005!!C!vi><\u0018N]3e\u0003\u0019)\u00070[:ugR!\u0011QCA\u000e!\ry\u0013qC\u0005\u0004\u00033\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003;a\u0001\u0019AA\u0010\u0003-!\u0017m\u001d5c_\u0006\u0014H-\u00133\u0011\t\u0005\u0005\u0012q\u0006\b\u0005\u0003G\tY\u0003E\u0002\u0002&Aj!!a\n\u000b\u0007\u0005%B&\u0001\u0004=e>|GOP\u0005\u0004\u0003[\u0001\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00022\u0005M\"AB*ue&twMC\u0002\u0002.AB3\u0001DA\u001c!\u0011\tI$!\u0012\u000e\u0005\u0005m\"\u0002BA\u0002\u0003{QA!a\u0010\u0002B\u00059Q.\u001a;sS\u000e\u001c(bAA\"U\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002H\u0005m\"!\u0002+j[\u0016$\u0017AB:fCJ\u001c\u0007\u000e\u0006\u0004\u0002N\u0005-\u0014q\u000e\t\u0007\u0003\u001f\nI&a\u0018\u000f\t\u0005E\u0013Q\u000b\b\u0005\u0003K\t\u0019&C\u00012\u0013\r\t9\u0006M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY&!\u0018\u0003\u0007M+\u0017OC\u0002\u0002XA\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\u0012\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0002j\u0005\r$!\u0003#bg\"\u0014w.\u0019:e\u0011\u001d\ti'\u0004a\u0001\u0003?\t\u0001\u0002]1sK:$\u0018\n\u001a\u0005\n\u0003cj\u0001\u0013!a\u0001\u0003?\tQ\u0001^5uY\u0016D3!DA\u001c\u0003A\u0019X-\u0019:dQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0002z)\"\u0011qDA>W\t\ti\b\u0005\u0003\u0002\u0000\u0005\u001dUBAAA\u0015\u0011\t\u0019)!\"\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0002a%!\u0011\u0011RAA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012M&tG\rR1tQ\n|\u0017M\u001d3Cs&#G\u0003BA0\u0003\u001fCq!!\b\u0010\u0001\u0004\ty\u0002K\u0002\u0010\u0003o\tqb\u0019:fCR,G)Y:iE>\f'\u000f\u001a\u000b\u0005\u0003?\n9\n\u0003\u0004$!\u0001\u0007\u0011q\f\u0015\u0004!\u0005]\u0012aD;qI\u0006$X\rR1tQ\n|\u0017M\u001d3\u0015\t\u0005}\u0013q\u0014\u0005\u0007GE\u0001\r!a\u0018)\u0007E\t9$A\beK2,G/\u001a#bg\"\u0014w.\u0019:e)\u0011\t9+!,\u0011\u0007=\nI+C\u0002\u0002,B\u0012A!\u00168ji\"9\u0011Q\u0004\nA\u0002\u0005}\u0001f\u0001\n\u00028\u0005)r-\u001a;ECND'm\\1sIR+W\u000e\u001d7bi\u0016\u001cH\u0003BA[\u0003\u0017\u0004b!a\u0014\u0002Z\u0005]\u0006\u0003BA]\u0003\u000fl!!a/\u000b\t\u0005u\u0016qX\u0001\be\u00164G.Z2u\u0015\u0011\t\t-a1\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002FR\u000ba\u0001\u001d7vO&t\u0017\u0002BAe\u0003w\u0013!\u0002R3tGJL\u0007\u000f^8s\u0011\u001d\tim\u0005a\u0001\u0003\u001f\fQa]2pa\u0016\u0004B!!\u0019\u0002R&!\u00111[A2\u0005%!\u0016\u000e\\3TG>\u0004X\rK\u0002\u0014\u0003o\tq\"\u001a<jGR$\u0016\u000e\\3t\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0003O\u000bY\u000e\u0003\u0004$)\u0001\u0007\u0011q\f\u0015\u0004)\u0005]\u0012!\b3fG>\u0014\u0018\r^3XSRDWI\u001a4fGRLg/Z*fGV\u0014\u0018\u000e^=\u0015\t\u00055\u00131\u001d\u0005\b\u0003K,\u0002\u0019AA'\u0003)!\u0017m\u001d5c_\u0006\u0014Hm]\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qUAv\u0011\u0019\u0019c\u00031\u0001\u0002`\u0005\t2/\u001a;Po:,'/\u00134NSN\u001c\u0018N\\4\u0015\t\u0005\u001d\u0016\u0011\u001f\u0005\u0007G]\u0001\r!a\u0018\u0002#\r,(O]3oiB\u0013\u0018N\\2ja\u0006d7/\u0006\u0002\u0002xB1\u0011\u0011`A\u0000\u0005\u0007i!!a?\u000b\u0007\u0005u\b'\u0001\u0006d_2dWm\u0019;j_:LAA!\u0001\u0002|\nA\u0011\n^3sC\ndW\r\u0005\u0003\u0003\u0006\t=QB\u0001B\u0004\u0015\u0011\u0011IAa\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001b\tAA[1wC&!\u0011\u0011\u0007B\u0004\u00031\u0019WO\u001d:f]R\u0014v\u000e\\3t+\t\u0011)\u0002\u0005\u0004\u0003\u0018\tu!\u0011E\u0007\u0003\u00053QAAa\u0007\u0002|\u00069Q.\u001e;bE2,\u0017\u0002\u0002B\u0010\u00053\u0011aAQ;gM\u0016\u0014\bcA)\u0003$%\u0019!Q\u0005*\u0003\tI{G.Z\u0001\u0013aJ|g/[:j_:$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0003,\tE\u0002cA\u0018\u0003.%\u0019!q\u0006\u0019\u0003\u0007\u0005s\u0017\u0010\u0003\u0004$5\u0001\u0007\u0011qL\u0001\u0017Kb,7-\u001e;f!J|g/[:j_:\u001c6M]5qiR!\u0011q\fB\u001c\u0011\u0019\u00193\u00041\u0001\u0002`\u00059\u0002O]8wSNLwN\u001c#bg\"\u0014w.\u0019:e)&dWm\u001d\u000b\u0005\u0003?\u0012i\u0004\u0003\u0004$9\u0001\u0007\u0011qL\u0001\u001bKb,7-\u001e;f)&dW\r\u0015:pm&\u001c\u0018n\u001c8TGJL\u0007\u000f\u001e\u000b\u0007\u0005\u0007\u0012IEa\u0013\u0011\t\u0005\u0005$QI\u0005\u0005\u0005\u000f\n\u0019G\u0001\u0003US2,\u0007BB\u0012\u001e\u0001\u0004\ty\u0006C\u0004\u0003Nu\u0001\rAa\u0011\u0002\tQLG.Z\u0001\u0014GJ,\u0017\r^3TGJL\u0007\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0005\u0005'\u0012Y\u0006\u0005\u0003\u0003V\t]S\"A/\n\u0007\teSL\u0001\tYYJ\u001c6M]5qi\u000e{g\u000e^3yi\"11E\ba\u0001\u0003?B3\u0001\u0001B0!\u0011\u0011\tGa\u001a\u000e\u0005\t\r$b\u0001B3\u0013\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t%$1\r\u0002\b'\u0016\u0014h/[2f\u0001")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public boolean exists(String dashboardId) {
        return this.dashboardRepository.exists(dashboardId);
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)new .colon.colon((Object)dashboard, (List)Nil$.MODULE$)));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardCreatedEvent(createdDashboard));
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboardTiles(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardUpdatedEvent(updatedDashboard));
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
        this.eventBus().publish((XLReleaseEvent)new DashboardDeletedEvent(dashboard));
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava(), (DecoratorCache<DashboardSecurityDecoratorCache>)new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1()).getDecoratorCache(""));
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        if (!dashboard.isReleaseDashboard()) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
        if (dashboard.getAutoRefresh() && (dashboard.getAutoRefreshInterval() == null || Predef$.MODULE$.Integer2int(dashboard.getAutoRefreshInterval()) < 1)) {
            throw new Checks.IncorrectArgumentException("Auto refresh interval must be larger then 0", new Object[]{dashboard.getAutoRefreshInterval()});
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    private Dashboard provisionDashboardTiles(Dashboard dashboard) {
        dashboard.setTiles((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dashboard.getTiles()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> this.executeTileProvisionScript(dashboard, (Tile)((Object)x$3)), Buffer$.MODULE$.canBuildFrom())).asJava());
        return dashboard;
    }

    private Tile executeTileProvisionScript(Dashboard dashboard, Tile tile) {
        Tile tile2;
        String scriptLocation = tile.getProvisioningScriptLocation();
        if (Ids.isNullId((String)tile.getId()) && Strings.isNotBlank((String)scriptLocation)) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            scriptContext.setAttribute("tile", (Object)tile, 100);
            String script = ScriptHelper.readScript((String)scriptLocation);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            tile2 = (Tile)((Object)scriptContext.getAttribute("tile"));
        } else {
            tile2 = tile;
        }
        return tile2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }
}

