import { Category, Workflow } from '../../../../../../../../../../../../../core/xlr-ui/app/types';

export interface WorkflowsByCategory {
    [key: string]: Array<Workflow>;
}

interface StartAndSpan {
    span: number;
    start: number;
}

interface CellProps {
    lg: StartAndSpan;
    md: StartAndSpan;
    sm: StartAndSpan;
    xs: StartAndSpan;
}

export const OTHER_CATEGORY = 'Other';
export const groupWorkflowsByCategory = (
    categories: Array<Category>,
    workflows: Array<Workflow>,
    searchFilter = '',
    authorFilter = '',
    // eslint-disable-next-line max-params
): WorkflowsByCategory => {
    const searchFilterInLowerCase = searchFilter.toLowerCase();
    const authorFilterInLowerCase = authorFilter.toLowerCase();
    const categoriesKeys: WorkflowsByCategory = { [OTHER_CATEGORY]: [] };
    for (const category of categories) {
        categoriesKeys[category.title] = [];
    }
    return workflows.reduce((acc, workflow) => {
        if (
            searchFilterInLowerCase &&
            !(workflow.title.toLowerCase().includes(searchFilterInLowerCase) || workflow.description?.toLowerCase().includes(searchFilterInLowerCase))
        ) {
            return acc;
        }
        if (authorFilterInLowerCase && !workflow.author?.toLowerCase().includes(authorFilterInLowerCase)) {
            return acc;
        }
        if (workflow.categories.length > 0) {
            workflow.categories.forEach((category) => {
                if (acc[category]) {
                    addWorkflowIntoCategory(category, acc, workflow);
                } else {
                    addWorkflowIntoCategory(OTHER_CATEGORY, acc, workflow);
                }
            });
        } else {
            addWorkflowIntoCategory(OTHER_CATEGORY, acc, workflow);
        }

        return acc;
    }, categoriesKeys);
};

const addWorkflowIntoCategory = (category: string, workflowList: WorkflowsByCategory, workflow: Workflow) => {
    // only add the workflow once
    if (!workflowList[category].find((w) => w.id === workflow.id)) {
        workflowList[category].push(workflow);
    }
};

export const calculateCellProps = (index: number): CellProps => {
    const sizeConstants = {
        lg: {
            columns: 12,
            cards: 3,
        },
        md: {
            columns: 12,
            cards: 2,
        },
        sm: {
            columns: 8,
            cards: 2,
        },
        xs: {
            columns: 4,
            cards: 1,
        },
    };

    return {
        lg: {
            start: (index % sizeConstants.lg.cards) * (sizeConstants.lg.columns / sizeConstants.lg.cards) + 1,
            span: sizeConstants.lg.columns / sizeConstants.lg.cards,
        },
        md: {
            start: (index % sizeConstants.md.cards) * (sizeConstants.md.columns / sizeConstants.md.cards) + 1,
            span: sizeConstants.md.columns / sizeConstants.md.cards,
        },
        sm: {
            start: (index % sizeConstants.sm.cards) * (sizeConstants.sm.columns / sizeConstants.sm.cards) + 1,
            span: sizeConstants.sm.columns / sizeConstants.sm.cards,
        },
        xs: {
            start: (index % sizeConstants.xs.cards) * (sizeConstants.xs.columns / sizeConstants.xs.cards) + 1,
            span: sizeConstants.xs.columns / sizeConstants.xs.cards,
        },
    };
};
