import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { Category, Folder, Workflow } from '../../../../../../../../../../../core/xlr-ui/app/types';

export interface WorkflowTileState {
    categories: Array<Category>;
    folders: Array<Folder>;
    isLoadingCategories: boolean;
    isLoadingFolders: boolean;
    isLoadingWorkflows: boolean;
    workflows: Array<Workflow>;
}

export const initialState: WorkflowTileState = {
    categories: [],
    folders: [],
    isLoadingCategories: false,
    isLoadingFolders: false,
    isLoadingWorkflows: false,
    workflows: [],
};

export interface RunWorkflowAction {
    folderId: string;
    workflow: Workflow;
}

export const workflowTile = createSlice({
    name: 'workflowTile',
    initialState,
    reducers: {
        init: (state) => {
            state.isLoadingWorkflows = true;
            state.isLoadingFolders = true;
            state.isLoadingCategories = true;
        },
        setCategories: (state, action: PayloadAction<Array<Category>>) => {
            state.categories = action.payload;
            state.isLoadingCategories = false;
        },
        setFolders: (state, action: PayloadAction<Array<Folder>>) => {
            state.folders = action.payload;
            state.isLoadingFolders = false;
        },
        setWorkflows: (state, action: PayloadAction<Array<Workflow>>) => {
            state.workflows = action.payload;
            state.isLoadingWorkflows = false;
        },
        runWorkflow: (_state, _action: PayloadAction<RunWorkflowAction>) => noop(),
    },
});

export const getWorkflowTileState = (state: RootState): WorkflowTileState => state.workflowTile;
