import React, { useState } from 'react';
import { WorkflowDrawer } from './drawer/workflow-drawer.component';
import { ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';

const workflowsImgSrc = 'static/@project.version@/styles/img/workflows_forms.svg';

export interface WorkflowTileProps {
    description: string;
    title: string;
}

export const WorkflowTile = ({ description, title }: WorkflowTileProps) => {
    const [isBottomDrawerVisible, setBottomDrawerVisible] = useState(false);

    const handlePrimaryButtonClick = () => {
        setBottomDrawerVisible(true);
    };

    const primaryButton: ButtonWithLink = {
        buttonCaption: 'Run workflow',
        onClick: handlePrimaryButtonClick,
        buttonType: 'outlined',
    };

    return (
        <>
            <CommonCardTileComponent description={description} imageLink={workflowsImgSrc} isMarkdown={true} primaryButton={primaryButton} title={title} />
            <WorkflowDrawer isOpen={isBottomDrawerVisible} onClose={() => setBottomDrawerVisible(false)} />
        </>
    );
};
