import { HomeTemplate } from '../active-template-tile.component';
import { getReleaseCountText, getUrlTemplateIdFromHomeTemplate } from './helpers';

describe('template tile helper functions', () => {
    describe('getUrlTemplateIdFromHomeTemplate', () => {
        const template: HomeTemplate = {
            releaseId: 'releaseId',
            releaseTitle: 'Test Release',
            folderName: 'test',
            folderId: 'folderId',
            folderPath: '/',
            lastEditedByUser: 1688372003150,
            releaseCount: 0,
        };

        it('should return template id for the url', () => {
            expect(getUrlTemplateIdFromHomeTemplate(template)).toBe('folderId-releaseId');
        });

        it('should return template id for the url when there is folderPath specified', () => {
            expect(getUrlTemplateIdFromHomeTemplate({ ...template, folderPath: '/testFolderPath' })).toBe('testFolderPath-folderId-releaseId');
        });

        it('should return template id for root templates', () => {
            expect(getUrlTemplateIdFromHomeTemplate({ ...template, folderId: '/' })).toBe('releaseId');
        });
    });

    describe('getReleaseCountText', () => {
        it('should return correct text when release count is 0', () => {
            expect(getReleaseCountText(0)).toBe('no releases started');
        });

        it('should return correct text when release count is 1', () => {
            expect(getReleaseCountText(1)).toBe('1 release started');
        });

        it('should return correct text when release count is bigger than 1', () => {
            expect(getReleaseCountText(5)).toBe('5 releases started');
        });
    });
});
