package com.xebialabs.xlrelease.plugins.dashboard.service

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.plugins.dashboard.repository.sql.persistence.HomeTilesSqlBuilder
import com.xebialabs.xlrelease.plugins.dashboard.repository.sql.persistence.HomeTilesSqlBuilder.{lastEditedByUserAlias, releasesCounterAlias}
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{FOLDERS, RELEASES}
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import com.xebialabs.xlrelease.repository.sql.persistence.{PersistenceSupport, Utils}
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.jdbc.core.{JdbcTemplate, RowMapper}
import org.springframework.stereotype.Service

import java.util.Date

case class TemplateHomeTileRow(releaseId: String,
                               releaseTitle: String,
                               folderName: String,
                               folderId: String,
                               folderPath: String,
                               lastEditedByUser: Date,
                               releaseCount: Int)

case class ReleaseHomeTileRow(releaseId: String,
                              releaseTitle: String,
                              releaseStatus: String,
                              startDate: Date,
                              endDate: Date,
                              folderName: String,
                              folderId: String,
                              folderPath: String,
                              lastEditedByUser: Date)

@Service
class HomeTilesQueryService(@Qualifier("xlrRepositoryJdbcTemplate") implicit val jdbcTemplate: JdbcTemplate,
                            @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect) extends Utils with PersistenceSupport {

  private val sqlBuilder = new HomeTilesSqlBuilder()

  def findLastEditedTemplates(username: String): Seq[TemplateHomeTileRow] = {

    val templateRowMapper: RowMapper[TemplateHomeTileRow] = (rs, _) => TemplateHomeTileRow(
      rs.getString(RELEASES.RELEASE_ID),
      rs.getString(RELEASES.RELEASE_TITLE),
      rs.getString(FOLDERS.NAME),
      rs.getString(FOLDERS.FOLDER_ID),
      rs.getString(FOLDERS.FOLDER_PATH),
      rs.getTimestamp(lastEditedByUserAlias),
      rs.getInt(releasesCounterAlias)
    )
    val templateQuery = sqlBuilder.lastTemplateEditedQuery(5)
    findMany(sqlQuery(templateQuery, params("username" -> username), templateRowMapper))
  }

  def findLastEditedReleases(username: String): Seq[ReleaseHomeTileRow] = {

    val releaseRowMapper: RowMapper[ReleaseHomeTileRow] = (rs, _) => ReleaseHomeTileRow(
      rs.getString(RELEASES.RELEASE_ID),
      rs.getString(RELEASES.RELEASE_TITLE),
      rs.getString(RELEASES.STATUS),
      rs.getTimestamp(RELEASES.START_DATE),
      rs.getTimestamp(RELEASES.END_DATE),
      rs.getString(FOLDERS.NAME),
      rs.getString(FOLDERS.FOLDER_ID),
      rs.getString(FOLDERS.FOLDER_PATH),
      rs.getTimestamp(lastEditedByUserAlias)
    )

    val releaseQuery = sqlBuilder.lastReleaseEditedQuery(5)
    findMany(sqlQuery(releaseQuery, params("username" -> username), releaseRowMapper))
  }

}
