import React from 'react';
import { DotAvatar, DotDivider, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { primaryButton, secondaryButton } from './tile-buttons-row.mock';
import { CommonActiveTile } from './common-active-tile.component';
import { TileButtonsRow } from './tile-buttons-row.component';

describe('CommonActiveTile', () => {
    const avatarIcon = 'template';
    const title = 'Templates';
    const content = <div>This is some content</div>;

    const mount = () => {
        return mountWithTheme(
            <CommonActiveTile avatarIcon={avatarIcon} content={content} primaryButton={primaryButton} secondaryButton={secondaryButton} title={title} />,
        );
    };

    const getTitleAvatar = (wrapper: ReactWrapper) => wrapper.find(DotAvatar).at(0);
    const getTitle = (wrapper: ReactWrapper) => wrapper.find(DotTypography).at(0);
    const getSubtitle = (wrapper: ReactWrapper) => wrapper.find(DotTypography).at(1);
    const getTileButtonsRow = (wrapper: ReactWrapper) => wrapper.find(TileButtonsRow);

    it('should render with correct props', () => {
        const wrapper = mount();

        const avatarProps = getTitleAvatar(wrapper).props();
        expect(avatarProps.alt).toBe(avatarIcon);
        expect(avatarProps.iconId).toBe(avatarIcon);
        expect(avatarProps.type).toBe('icon');

        const titleProps = getTitle(wrapper).props();
        expect(titleProps.variant).toBe('h2');
        expect(titleProps.children).toBe(title);

        const subtitleProps = getSubtitle(wrapper).props();
        expect(subtitleProps.className).toBe('active-tile-subtitle');
        expect(subtitleProps.variant).toBe('body1');
        expect(subtitleProps.children).toBe('Last updated - Most recent 5');

        expect(wrapper.find('.active-tile-content')).toExist();

        const tileButtonsRowProps = getTileButtonsRow(wrapper).props();
        expect(tileButtonsRowProps.primaryButton).toBe(primaryButton);
        expect(tileButtonsRowProps.alignButtonsRight).toBe(true);
        expect(tileButtonsRowProps.secondaryButton).toBe(secondaryButton);

        expect(wrapper.find(DotDivider)).toHaveLength(2);
    });
});
