import React from 'react';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WorkflowCategoriesSkeleton } from './workflow-categories-skeleton.component';
import { CheckboxSkeleton } from './checkbox-skeleton.component';
import * as helpers from '../helper';

describe('WorkflowCategoriesSkeleton', () => {
    const mountComponent = () => mountWithTheme(<WorkflowCategoriesSkeleton />);
    const getWrapperDiv = (wrapper: ReactWrapper) => wrapper.find('div.workflow-categories-skeleton');
    const getCheckboxItemsWrapperDiv = (wrapper: ReactWrapper) => wrapper.find('div.workflow-category-checkbox-items');

    it('should render properly', () => {
        const numberOfItems = 4;
        const getRandomIntSpy = jest.spyOn(helpers, 'getRandomInt').mockReturnValue(numberOfItems);

        const wrapper = mountComponent();

        const wrapperDiv = getWrapperDiv(wrapper);
        expect(wrapperDiv).toExist();

        const selectAllCheckboxSkeleton = wrapperDiv.childAt(0).find(CheckboxSkeleton);
        expect(selectAllCheckboxSkeleton).toExist();

        const checkboxItemsWrapperDiv = getCheckboxItemsWrapperDiv(wrapper);
        expect(checkboxItemsWrapperDiv).toExist();

        const checkboxSkeletons = checkboxItemsWrapperDiv.find(CheckboxSkeleton);
        expect(checkboxSkeletons).toExist();
        expect(checkboxSkeletons).toHaveLength(numberOfItems);

        getRandomIntSpy.mockRestore();
    });
});
