import React from 'react';
import {
    DotAvatar,
    DotButton,
    DotCard,
    DotCardContent,
    DotCardFooter,
    DotCardHeader,
    DotIcon,
    DotLink,
    DotPill,
    DotTypography,
} from '@digital-ai/dot-components';
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-ignore we don't have types
import parseGitUrl from 'parse-github-url';
import { Workflow } from '../../../../../../../../../../../../core/xlr-ui/app/types';
import './workflow-card.component.less';

interface WorkflowCardProps {
    onClick: (id: string) => void;
    workflow: Workflow;
}

export const WorkflowCard = ({ workflow, onClick }: WorkflowCardProps) => {
    const { id, title, author, description, scmTraceabilityData, logo, folderTitle } = workflow;

    const handleOnOpen = () => {
        onClick(id);
    };

    const cardLogo = logo ? (
        <DotAvatar alt={title} imageSrc={`api/v1/templates/logo/${logo.id}`} type="image" />
    ) : (
        <DotAvatar alt={title} text={''} type="text" />
    );

    const renderCommitLink = () => {
        if (!scmTraceabilityData.commit) return;

        const buildUrlForGithub = () => {
            // looks like we are only compatible with github links? code from scm-commit-data-modal-component.js
            if (!scmTraceabilityData.remote?.includes('github')) return;
            const url = parseGitUrl(scmTraceabilityData.remote);
            return `https://${url.host}/${url.owner}/${url.name}/commit/${scmTraceabilityData.commit}`;
        };

        const commitUrl = buildUrlForGithub();

        const commitHash = scmTraceabilityData.commit.substring(0, 8);

        return (
            <div className="dot-card-spacing">
                <DotTypography variant="body1">
                    <strong>Git version: </strong>
                    {commitUrl ? (
                        <DotLink href={commitUrl} target="_blank">
                            {commitHash}
                        </DotLink>
                    ) : (
                        <>{commitHash}</>
                    )}
                </DotTypography>
            </div>
        );
    };

    return (
        <DotCard className="workflow-card">
            <div>
                <DotCardHeader avatar={cardLogo} subheader={author ? `by ${author}` : undefined} subheaderSize="large" title={title} titleSize="large" />
                <DotCardContent>
                    <div className="dot-card-spacing">
                        <DotTypography variant="body1">{description}</DotTypography>
                    </div>
                    {renderCommitLink()}
                    <div className="dot-card-spacing">
                        <DotPill backgroundcolor="white" icon={<DotIcon iconId="folder" />} label={folderTitle} variant="outlined" />
                    </div>
                </DotCardContent>
            </div>
            <DotCardFooter>
                <DotButton onClick={handleOnOpen} type="outlined">
                    Run workflow
                </DotButton>
            </DotCardFooter>
        </DotCard>
    );
};
