import React, { ReactNode } from 'react';
import { DotAvatar, DotDivider, DotTypography } from '@digital-ai/dot-components';
import { TileButtonsRow } from './tile-buttons-row.component';
import { ButtonWithLink } from './common-card-tile.component';
import './common-active-tile.component.less';

interface CommonActiveTileProps {
    avatarIcon: string;
    content: ReactNode;
    primaryButton: ButtonWithLink;
    secondaryButton?: ButtonWithLink;
    title: string;
}

export const CommonActiveTile = ({ avatarIcon, content, primaryButton, secondaryButton, title }: CommonActiveTileProps) => {
    return (
        <div className="active-tile">
            <div className="active-tile-header">
                <DotAvatar alt={avatarIcon} iconId={avatarIcon} type="icon" />
                <div>
                    <DotTypography variant="h2">{title}</DotTypography>
                    <DotTypography className="active-tile-subtitle" variant="body1">
                        Last updated - Most recent 5
                    </DotTypography>
                </div>
            </div>
            <DotDivider />
            <div className="active-tile-content">{content}</div>
            <div className="active-tile-footer">
                <DotDivider />
                <TileButtonsRow alignButtonsRight primaryButton={primaryButton} secondaryButton={secondaryButton} />
            </div>
        </div>
    );
};
