import React from 'react';
import { CssCell, CssGrid, DotSkeleton, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import * as helpers from '../helper';
import { WorkflowSkeletons } from './workflow-skeletons.component';
import { WorkflowCardSkeleton } from './workflow-card-skeleton.component';

describe('WorkflowSkeletons', () => {
    const mountComponent = () => mountWithTheme(<WorkflowSkeletons />);
    const getCategories = (wrapper: ReactWrapper) => wrapper.find('div.workflow-skeletons-category');

    it('should render properly', () => {
        const numberOfItems = 2;
        const getRandomIntSpy = jest.spyOn(helpers, 'getRandomInt').mockReturnValue(numberOfItems);

        const wrapper = mountComponent();

        const categories = getCategories(wrapper);
        expect(categories).toExist();
        expect(categories).toHaveLength(numberOfItems);

        categories.forEach((category) => {
            const categoryTitlesTypography = category.findWhere(
                (node) => node.is(DotTypography) && node.props().className === 'workflow-skeletons-category-title',
            );
            expect(categoryTitlesTypography).toExist();
            const dotSkeleton = categoryTitlesTypography.find(DotSkeleton);
            expect(dotSkeleton).toExist();
            expect(dotSkeleton.props().variant).toBe('rectangular');
            expect(categoryTitlesTypography.props().variant).toBe('h3');

            const cssGrid = category.find(CssGrid);
            expect(cssGrid).toExist();

            const cssCells = cssGrid.find(CssCell);
            expect(cssCells).toExist();
            expect(cssCells).toHaveLength(numberOfItems);

            cssCells.forEach((cssCell) => {
                const workflowCardSkeleton = cssCell.find(WorkflowCardSkeleton);
                expect(workflowCardSkeleton).toExist();
            });
        });

        getRandomIntSpy.mockRestore();
    });
});
