import React from 'react';
import { DotDrawer, DotIconButton, DotTabs } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WorkflowDrawer, WorkflowDrawerProps } from './workflow-drawer.component';
import { initialState } from '../ducks/workflow-tile.reducer';

describe('WorkflowDrawer', () => {
    const onClose = jest.fn();
    const dispatch = jest.fn();
    const defaultProps: WorkflowDrawerProps = {
        isOpen: true,
        onClose,
    };

    const mountComponent = (props: WorkflowDrawerProps = defaultProps) =>
        mountWithStoreAndTheme(<WorkflowDrawer {...props} />, dispatch, { workflowTile: initialState });

    const getDrawer = (wrapper: ReactWrapper) => wrapper.find(DotDrawer);
    const getTabs = (wrapper: ReactWrapper) => wrapper.find(DotTabs);
    const getIconButton = (wrapper: ReactWrapper) => wrapper.find(DotIconButton);
    const getWorkflowDrawerLeftContent = (wrapper: ReactWrapper) => wrapper.find('.workflow-drawer-content-left');

    it('should render properly', () => {
        const wrapper = mountComponent();

        const drawerProps = getDrawer(wrapper).props();
        expect(drawerProps.PaperProps).toStrictEqual({
            style: {
                top: '48px',
                padding: 0,
            },
        });
        expect(drawerProps.anchor).toBe('bottom');
        expect(drawerProps.className).toBe('workflow-drawer');
        expect(drawerProps.open).toBe(true);

        const tabsProps = getTabs(wrapper).props();
        expect(tabsProps.tabs).toStrictEqual([{ label: 'Workflow catalog' }]);

        const iconButtonProps = getIconButton(wrapper).props();
        expect(iconButtonProps.iconId).toBe('close');
        expect(iconButtonProps.tooltip).toBe('Close');

        expect(getWorkflowDrawerLeftContent(wrapper)).toExist();
    });

    it('should not render tabs, close button and content if isOpen is false', () => {
        const wrapper = mountComponent({ ...defaultProps, isOpen: false });
        expect(getDrawer(wrapper).props().open).toBe(false);
        expect(getTabs(wrapper)).not.toExist();
        expect(getIconButton(wrapper)).not.toExist();
        expect(getWorkflowDrawerLeftContent(wrapper)).not.toExist();
    });

    it('should call close handler when clicking Close button', () => {
        const wrapper = mountComponent();
        getIconButton(wrapper).invoke('onClick')?.('' as never);
        expect(onClose).toBeCalled();
    });
});
