import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { ApplicationTileData } from '../active-application-tile.component';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';

export interface ApplicationTileState {
    allFolders: Array<Folder>;
    applicationDialogOpen: boolean;
    applicationTileData: ApplicationTileData;
    isLoading: boolean;
}

export const initialState: ApplicationTileState = {
    allFolders: [],
    applicationDialogOpen: false,
    applicationTileData: {
        applications: [],
        folders: [],
        total: 0,
    },
    isLoading: true,
};

export const applicationTile = createSlice({
    name: 'applicationTile',
    initialState,
    reducers: {
        loadApplicationTileData: (state) => {
            state.isLoading = true;
        },
        loadAllFolders: (_state) => noop(),
        setApplicationTileData: (state, action: PayloadAction<ApplicationTileData>) => {
            state.applicationTileData = action.payload;
            state.isLoading = false;
        },
        setApplicationDialogOpen: (state, action: PayloadAction<boolean>) => {
            state.applicationDialogOpen = action.payload;
        },
        setFolders: (state, action: PayloadAction<Array<Folder>>) => {
            state.allFolders = action.payload;
        },
    },
});

export const getApplicationTileState = (state: RootState): ApplicationTileState => state.applicationTile;
