import React from 'react';
import { DotDivider } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { primaryButton, secondaryButton } from './tile-buttons-row.mock';
import { CommonActiveTile } from './common-active-tile.component';
import { TileButtonsRow } from './tile-buttons-row.component';
import { CommonTileHeader } from './common-tile-header.component';

describe('CommonActiveTile', () => {
    const avatarIcon = 'template';
    const title = 'Templates';
    const subtitle = 'Most recent';
    const content = <div>This is some content</div>;

    const mount = () => {
        return mountWithTheme(
            <CommonActiveTile
                avatarIcon={avatarIcon}
                content={content}
                primaryButton={primaryButton}
                secondaryButton={secondaryButton}
                subtitle={subtitle}
                title={title}
            />,
        );
    };

    const getCommonTileHeader = (wrapper: ReactWrapper) => wrapper.find(CommonTileHeader);
    const getTileButtonsRow = (wrapper: ReactWrapper) => wrapper.find(TileButtonsRow);

    it('should render with correct props', () => {
        const wrapper = mount();

        const tileHeaderProps = getCommonTileHeader(wrapper).props();
        expect(tileHeaderProps.title).toBe(title);
        expect(tileHeaderProps.subtitle).toBe(subtitle);
        expect(tileHeaderProps.avatarIcon).toBe(avatarIcon);

        expect(wrapper.find('.active-tile-content')).toExist();

        const tileButtonsRowProps = getTileButtonsRow(wrapper).props();
        expect(tileButtonsRowProps.primaryButton).toBe(primaryButton);
        expect(tileButtonsRowProps.alignButtonsRight).toBe(true);
        expect(tileButtonsRowProps.secondaryButton).toBe(secondaryButton);

        expect(wrapper.find(DotDivider)).toHaveLength(2);
    });
});
