import React from 'react';
import { DotCardFooter, DotButton } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnnouncementTile, AnnouncementTileProps } from './announcement-tile.component';
import * as angularAccessor from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { VariablesInterpolatorFactory } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';

describe('AnnouncementTile', () => {
    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<VariablesInterpolatorFactory, [name: unknown]>;

    const description = 'my description';
    const buttonCaption = 'my button';
    const buttonLink = '#/button';
    const buttonType = 'text';
    const imageLink = 'egg.png';
    const title = 'title';

    const defaultProps: AnnouncementTileProps = { description, buttonCaption, buttonLink, buttonType, title, imageLink };

    const mount = (props: AnnouncementTileProps = defaultProps) => {
        return mountWithTheme(<AnnouncementTile {...props} />);
    };

    const getButton = (wrapper: ReactWrapper) => wrapper.find(DotCardFooter).find(DotButton);
    const getCommonCardTileComponent = (wrapper: ReactWrapper) => wrapper.find(CommonCardTileComponent);

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            interpolateInText: jest.fn().mockReturnValue(''),
        });
    });

    it('should render', () => {
        const wrapper = mount();
        const commonCard = getCommonCardTileComponent(wrapper);
        const commonCardProps = commonCard.props();
        expect(commonCardProps.title).toBe(title);
        expect(commonCardProps.secondaryButton).toBeUndefined();
        expect(commonCardProps.primaryButton.buttonType).toBe(buttonType);
        expect(commonCardProps.primaryButton.buttonCaption).toBe(buttonCaption);
        expect(commonCardProps.description).toBe(description);
        expect(commonCardProps.imageLink).toBe(imageLink);
        expect(commonCardProps.isMarkdown).toBe(true);
    });

    it('should handle internal links on click', () => {
        const wrapper = mount();
        const button = getButton(wrapper);
        button.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/button`);
    });

    it('should handle external links on click', () => {
        jest.spyOn(window, 'open').mockImplementation(() => null);
        const wrapper = mount({ ...defaultProps, buttonLink: 'https://www.coolblue.nl' });
        const button = getButton(wrapper);
        button.invoke('onClick')?.('' as never);
        expect(window.open).toHaveBeenCalledWith('https://www.coolblue.nl', '_blank');
    });
});
