import React from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import './empty-data.component.less';

export interface EmptyDataProps {
    imageLink: string;
    message: string;
}

export const EmptyData = ({ imageLink, message }: EmptyDataProps) => {
    return (
        <div className="empty-data">
            <DotTypography variant="body1">{message}</DotTypography>
            <img alt="no-data-image" src={imageLink}></img>
        </div>
    );
};
