import React from 'react';
import { DotCardFooter, DotButton, DotDialog } from '@digital-ai/dot-components';
import constant from 'lodash/constant';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WelcomeTile, WelcomeTileProps } from './welcome-tile.component';
import * as angularAccessor from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { VariablesInterpolatorFactory } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';

describe('WelcomeTile', () => {
    const getAngularServiceSpy = jest.spyOn(angularAccessor, 'default') as unknown as jest.SpyInstance<VariablesInterpolatorFactory, [name: unknown]>;

    const description = 'my description';
    const title = 'title';

    const defaultProps: WelcomeTileProps = { description, title };

    const mount = (props: WelcomeTileProps = defaultProps) => {
        return mountWithTheme(<WelcomeTile {...props} />);
    };

    const getButton = (wrapper: ReactWrapper) => wrapper.find(DotCardFooter).find(DotButton);
    const getCommonCardTileComponent = (wrapper: ReactWrapper) => wrapper.find(CommonCardTileComponent);
    const getDialog = (wrapper: ReactWrapper) => wrapper.find(DotDialog);

    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    const togglePendo = (enabled: boolean) => (window.pendo = { isSendingEvents: constant(enabled) });

    beforeEach(() => {
        getAngularServiceSpy.mockReturnValue({
            interpolateInText: jest.fn().mockReturnValue(''),
        });
    });

    afterEach(() => {
        togglePendo(false);
    });

    it('should render', () => {
        const wrapper = mount();
        const commonCard = getCommonCardTileComponent(wrapper);
        const commonCardProps = commonCard.props();
        expect(commonCardProps.title).toBe(title);
        expect(commonCardProps.secondaryButton).toBeUndefined();
        expect(commonCardProps.primaryButton.buttonType).toBe('primary');
        expect(commonCardProps.primaryButton.buttonCaption).toBe('Take quick tour');
        expect(commonCardProps.primaryButton['data-testid']).toBe('welcome-tile-btn');
        expect(commonCardProps.description).toBe(description);
        expect(commonCardProps.imageLink).toBe('static/23.3.12/styles/img/pana.svg');
        expect(commonCardProps.isMarkdown).toBe(true);
    });

    it('should do nothing if pendo is enabled', () => {
        togglePendo(true);
        const wrapper = mount();
        const button = getButton(wrapper);
        button.invoke('onClick')?.('' as never);

        expect(getDialog(wrapper)).not.toExist();
    });

    it('should show dialog on click when pendo is not enabled', () => {
        togglePendo(false);

        const wrapper = mount();
        const button = getButton(wrapper);
        button.invoke('onClick')?.('' as never);

        const dialog = getDialog(wrapper);
        expect(dialog).toIncludeText(
            'You do not have Analytics and guide functionality enabled. Please contact your Release Administrator for more information.',
        );
        const dialogProps = dialog.props();
        expect(dialogProps.cancelButtonVisible).toBe(false);
        expect(dialogProps.closeIconVisible).toBe(false);
        expect(dialogProps.closeOnClickAway).toBe(false);
        expect(dialogProps.open).toBe(true);
        expect(dialogProps.submitButtonProps).toStrictEqual({
            label: 'Ok',
        });
        expect(dialogProps.title).toBe('Analytics');

        dialog.invoke('onSubmit')?.('' as never);
        expect(getDialog(wrapper)).not.toExist();
    });
});
