import { applicationTile, initialState } from './application-tile.reducer';
import { ApplicationTileData } from '../active-application-tile.component';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';

const { loadApplicationTileData, loadAllFolders, setApplicationTileData, setApplicationDialogOpen, setFolders } = applicationTile.actions;

describe('application tile reducer', () => {
    it('should have the initial state', () => {
        expect(applicationTile.name).toBe('applicationTile');
        expect(Object.keys(applicationTile.actions)).toStrictEqual([
            'loadApplicationTileData',
            'loadAllFolders',
            'setApplicationTileData',
            'setApplicationDialogOpen',
            'setFolders',
        ]);
        expect(applicationTile.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('loadApplicationTileData', () => {
            it('should set isLoading to true', () => {
                expect(applicationTile.reducer(initialState, loadApplicationTileData())).toStrictEqual({ ...initialState, isLoading: true });
            });
        });

        describe('loadAllFolders', () => {
            it('should do nothing with the state', () => {
                expect(applicationTile.reducer(initialState, loadAllFolders())).toStrictEqual(initialState);
            });
        });

        describe('setApplicationTileData', () => {
            const applicationTileData: ApplicationTileData = {
                applications: [
                    {
                        appCreateDate: 1690187050870,
                        appEnvironment: 'test environment',
                        appId: 'appId',
                        appName: 'Test App',
                        folderId: 'folderId',
                        folderName: 'test',
                        folderPath: '/',
                    },
                ],
                folders: [
                    {
                        folderId: 'folderId',
                        folderName: 'test',
                        folderPath: '/',
                        total: 1,
                    },
                ],
                total: 1,
            };

            it('should set applicationTileData and set isLoading to false', () => {
                expect(applicationTile.reducer(initialState, setApplicationTileData(applicationTileData))).toStrictEqual({
                    ...initialState,
                    applicationTileData,
                    isLoading: false,
                });
            });
        });

        describe('setApplicationDialogOpen', () => {
            it('should set applicationDialogOpen', () => {
                expect(applicationTile.reducer(initialState, setApplicationDialogOpen(true))).toStrictEqual({ ...initialState, applicationDialogOpen: true });
                expect(applicationTile.reducer(initialState, setApplicationDialogOpen(false))).toStrictEqual({ ...initialState, applicationDialogOpen: false });
            });
        });

        describe('setFolders', () => {
            const allFolders: Array<Folder> = [
                {
                    children: [
                        {
                            id: 'Applications/folderId10',
                            title: 'Title Inside',
                        },
                    ],
                    id: 'Applications/folderId1',
                    title: 'Title One',
                },
                {
                    id: 'Applications/folderId2',
                    title: 'Title Two',
                },
            ];

            it('should set allFolders', () => {
                expect(applicationTile.reducer(initialState, setFolders(allFolders))).toStrictEqual({ ...initialState, allFolders });
            });
        });
    });
});
