import { SagaIterator } from 'redux-saga';
import { all, call, put, takeLatest } from 'redux-saga/effects';
import { IHttpResponse } from 'angular';
import { httpGET } from '../../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { applicationTile } from './application-tile.reducer';
import applicationTileSaga, { loadAllFoldersSaga, loadApplicationTileDataSaga } from './application-tile.saga';
import { ApplicationTileData } from '../active-application-tile.component';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import getAngularService from '../../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { FoldersService } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/types/angular';

const { loadApplicationTileData, loadAllFolders, setApplicationTileData, setFolders } = applicationTile.actions;

describe('applicationTileSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = applicationTileSaga();
        expect(gen.next().value).toStrictEqual(
            all([takeLatest(loadApplicationTileData, loadApplicationTileDataSaga), takeLatest(loadAllFolders, loadAllFoldersSaga)]),
        );
        expect(gen.next().done).toBe(true);
    });

    describe('loadApplicationTileDataSaga', () => {
        const applicationTileData: ApplicationTileData = {
            applications: [
                {
                    appCreateDate: 1690187050870,
                    appEnvironment: 'test environment',
                    appId: 'appId',
                    appName: 'Test App',
                    folderId: 'folderId',
                    folderName: 'test',
                    folderPath: '/',
                },
            ],
            folders: [
                {
                    folderId: 'folderId',
                    folderName: 'test',
                    folderPath: '/',
                    total: 1,
                },
            ],
            total: 1,
        };

        it('should load and set application tile data', () => {
            const gen: SagaIterator = loadApplicationTileDataSaga();
            expect(gen.next().value).toStrictEqual(call(httpGET, 'home-tile/applications'));
            expect(gen.next({ data: applicationTileData }).value).toMatchObject(put(setApplicationTileData(applicationTileData)));
            expect(gen.next().done).toBeTruthy();
        });
    });

    describe('loadAllFoldersSaga', () => {
        const foldersService: FoldersService = {
            getListOrCachedPromise: jest.fn(),
        };

        const allFolders: Array<Folder> = [
            {
                children: [
                    {
                        id: 'Applications/folderId10',
                        title: 'Title Inside',
                    },
                ],
                id: 'Applications/folderId1',
                title: 'Title One',
            },
            {
                id: 'Applications/folderId2',
                title: 'Title Two',
            },
        ];

        const folderResponse: IHttpResponse<Array<Folder>> = {
            data: allFolders,
        } as never;

        it('should load and set all folders', () => {
            const gen: SagaIterator = loadAllFoldersSaga();
            expect(gen.next().value).toStrictEqual(call(getAngularService, 'FoldersService'));
            expect(gen.next(foldersService).value).toStrictEqual(call([foldersService, foldersService.getListOrCachedPromise], false));
            expect(gen.next(folderResponse).value).toMatchObject(put(setFolders(allFolders)));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
