package com.xebialabs.xlrelease.plugins.dashboard.api.internal

import com.fasterxml.jackson.databind.ObjectMapper
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardService
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView.toDashboard
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.security.PermissionChecker
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import javax.ws.rs._
import javax.ws.rs.core.MediaType

@Path("fixtures/dashboard")
@Controller
@Produces(Array(MediaType.APPLICATION_JSON))
@Consumes(Array(MediaType.APPLICATION_JSON))
class FixturesDashboardResource @Autowired()(val dashboardService: DashboardService,
                                             implicit val configurationRepository: ConfigurationRepository,
                                             implicit val objectMapper: ObjectMapper,
                                             val permissions: PermissionChecker) {

  @POST
  def createDashboard(dashboard: DashboardView): DashboardView = {
    permissions.check(ADMIN)
    val createdDashboard = dashboardService.createDashboard(toDashboard(dashboard))
    DashboardView(createdDashboard)
  }

  @DELETE
  @Path("{dashboardId:.*}")
  def deleteDashboard(@PathParam("dashboardId") dashboardId: String): Unit = {
    permissions.check(ADMIN)
    if (dashboardService.exists(dashboardId)) {
      dashboardService.deleteDashboard(dashboardId)
    }
  }
}
