package com.xebialabs.xlrelease.plugins.dashboard.upgrade

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}
import com.xebialabs.xlrelease.plugins.dashboard.repository.SqlDashboardRepository
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardService
import com.xebialabs.xlrelease.service.CiIdService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._


@Component
class XLRelease233HomeDashboardUpgrade @Autowired()(val dashboardService: DashboardService,
                                                    val sqlDashboardRepository: SqlDashboardRepository,
                                                    val ciIdService: CiIdService) extends BaseInitializingUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.3.0#0")

  override def doUpgrade(): Boolean = {
    val homeDashboard: Dashboard = Type.valueOf("xlrelease.HomeDashboard").getDescriptor.newInstance(Dashboard.HOME_DASHBOARD_ID)
    dashboardService.provisionDashboard(homeDashboard)
    setNewTileIds(homeDashboard)
    sqlDashboardRepository.createDashboard(homeDashboard, generateIds = false)
    true
  }

  private def setNewTileIds(dashboard: Dashboard): Unit = {
    dashboard.getTiles
      .asScala
      .filter(t => nullId(t.getId))
      .foreach(_.setId(newTileId(dashboard)))
  }

  private def newTileId(dashboard: Dashboard): String = {
    ciIdService.getUniqueId(Type.valueOf(classOf[Tile]), dashboard.getId)
  }

  private def nullId(id: String): Boolean = {
    id == null || id.trim.isEmpty || id.trim.toLowerCase == "null"
  }

}
