package com.xebialabs.xlrelease.plugins.dashboard.views

import com.xebialabs.xlrelease.plugins.dashboard.service.{WorkflowUserGroupedTile, WorkflowUserTile}

import scala.jdk.CollectionConverters._
import java.util.Date
import java.util.{List => JList}
import scala.beans.BeanProperty

class WorkflowHomeTileView(val tile: WorkflowUserTile) {
  @BeanProperty var releaseId: String = tile.releaseId
  @BeanProperty var releaseTitle: String = tile.releaseTitle
  @BeanProperty var releaseStatus: String = tile.releaseStatus
  @BeanProperty var releaseStartDate: Date = tile.releaseStartDate
  @BeanProperty var releaseEndDate: Date = tile.releaseEndDate
  @BeanProperty var folderName: String = tile.folderName
  @BeanProperty var folderId: String = tile.folderId
  @BeanProperty var folderPath: String = tile.folderPath
  @BeanProperty var categories: JList[String] = tile.categories.asJava
  @BeanProperty var logoId: String = tile.logoId.orNull
}

class WorkflowRecentRunningTileView(val groupedTile: WorkflowUserGroupedTile) {
  @BeanProperty var recent: JList[WorkflowHomeTileView] = groupedTile.recent.map(new WorkflowHomeTileView(_)).asJava
  @BeanProperty var running: JList[WorkflowHomeTileView] = groupedTile.running.map(new WorkflowHomeTileView(_)).asJava
}
