import React, { useEffect } from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { Provider } from 'react-redux';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { navigation } from '../../../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { store } from '../../../ducks/global-dashboad-store';
import { getGlobalDashboardState, globalDashboard, GlobalDashboardState } from '../../../ducks/global-dashboard.reducer';
import { Dashboard } from '../../../types';
import { DashboardList } from './dashboard-list.component';
import './global-dashboard-list.component.less';

const { loadGlobalDashboards, executeDashboardAction, searchWithFilter } = globalDashboard.actions;
const { navigateTo } = navigation.actions;

export interface GlobalDashboardFilters {
    title?: string;
}

interface GlobalDashboardListProps {
    filters: GlobalDashboardFilters;
}

export const GlobalDashboardList = (props: GlobalDashboardListProps) => {
    return (
        <Provider store={store}>
            <DotThemeProvider>
                <GlobalDashboardListContent {...props} />
            </DotThemeProvider>
        </Provider>
    );
};

export const GlobalDashboardListContent = ({ filters }: GlobalDashboardListProps) => {
    const dispatch = useAppDispatch();
    const { loading, dashboards, hasCreateDashboardPermission, titleFilter }: GlobalDashboardState = useAppSelector(getGlobalDashboardState);

    useEffect(() => {
        dispatch(loadGlobalDashboards(filters));
    }, []);

    const handleNewDashboard = () => {
        dispatch(navigateTo({ pathSuffix: 'dashboards/new' }));
    };

    const handleDashboardFilterChange = (title: string) => {
        dispatch(searchWithFilter(title));
    };

    const handleDelete = (dashboardId: string) => {
        const dashboardToDelete = dashboards.find((currentDashboard) => currentDashboard.id === dashboardId);
        if (!dashboardToDelete) return;
        dispatch(executeDashboardAction({ actionId: 'DELETE', dashboard: dashboardToDelete }));
    };

    const handleDuplicate = (currentDashboard: Dashboard) => {
        dispatch(executeDashboardAction({ actionId: 'DUPLICATE', dashboard: currentDashboard }));
    };

    return (
        <DashboardList
            dashboardTitleFilter={titleFilter}
            dashboards={dashboards}
            hasCreateDashboardPermission={hasCreateDashboardPermission}
            isLoading={loading}
            onCreate={handleNewDashboard}
            onDelete={handleDelete}
            onDuplicate={handleDuplicate}
            onFilterChange={handleDashboardFilterChange}
        />
    );
};
