/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardCreatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardDeletedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardUpdatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardScriptContext$;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecoratorCache;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.script.jython.XlrJythonSupport;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u0011\"\u00019B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!q\u0007A!A!\u0002\u0013y\u0007\u0002C<\u0001\u0005\u000b\u0007I\u0011\u0001=\t\u0011q\u0004!\u0011!Q\u0001\neD\u0001\" \u0001\u0003\u0006\u0004%\tA \u0005\n\u0003\u0017\u0001!\u0011!Q\u0001\n}D!\"!\u0004\u0001\u0005\u000b\u0007I1AA\b\u0011)\tY\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u001d\u0001\t\u0003\t\u0019\bC\u0005\u0002\"\u0002\t\n\u0011\"\u0001\u0002$\"I\u0011q\u0017\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0018\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!!4\u0001\t\u0003\ty\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u0011i\u0002\u0001C\t\u0005?AqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u0003,\u0001!IA!\f\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!q\n\u0001\u0005\n\tE\u0003b\u0002B3\u0001\u0011%!q\r\u0005\b\u0005W\u0002A\u0011\u0002B7\u0005A!\u0015m\u001d5c_\u0006\u0014HmU3sm&\u001cWM\u0003\u0002#G\u000591/\u001a:wS\u000e,'B\u0001\u0013&\u0003%!\u0017m\u001d5c_\u0006\u0014HM\u0003\u0002'O\u00059\u0001\u000f\\;hS:\u001c(B\u0001\u0015*\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002+W\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002Y\u0005\u00191m\\7\u0004\u0001M!\u0001aL\u001b>!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0006g24GG\u001b\u0006\u0002u\u0005AqM]5{u2,G-\u0003\u0002=o\t9Aj\\4hS:<\u0007C\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0019Q\u0017\u0010\u001e5p]*\u0011!iJ\u0001\u0007g\u000e\u0014\u0018\u000e\u001d;\n\u0005\u0011{$\u0001\u0005-me*KH\u000f[8o'V\u0004\bo\u001c:u\u0003M!\u0017m\u001d5c_\u0006\u0014HMU3q_NLGo\u001c:z!\t9%*D\u0001I\u0015\tI5%\u0001\u0006sKB|7/\u001b;pefL!a\u0013%\u0003;\u0011+G.Z4bi&tw\rR1tQ\n|\u0017M\u001d3SKB|7/\u001b;pef\f\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z!\tqu*D\u0001\"\u0013\t\u0001\u0016EA\tECND'm\\1sIN+7-\u001e:jif\f!\u0004Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z\t\u0016\u001cwN]1u_J\u0004\"AT*\n\u0005Q\u000b#A\u0007#bg\"\u0014w.\u0019:e'\u0016\u001cWO]5us\u0012+7m\u001c:bi>\u0014\u0018\u0001D2bG\",W*\u00198bO\u0016\u0014\bCA,_\u001b\u0005A&BA-[\u0003\u0015\u0019\u0017m\u00195f\u0015\tYF,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005i\u0016aA8sO&\u0011q\f\u0017\u0002\r\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0015\u0005\t\u0005\\G\u000e\u0005\u0002cS6\t1M\u0003\u0002eK\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0019<\u0017a\u00024bGR|'/\u001f\u0006\u0003Qj\u000bQAY3b]NL!A[2\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A7\u0002!QLG.Z\"bG\",W*\u00198bO\u0016\u0014\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\u0011M,7-\u001e:jifT!\u0001^\u0015\u0002\u0011\u0011,\u0007\u000f\\8zSRL!A^9\u0003\u0017I{G.Z*feZL7-Z\u0001\u000eg\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\u0016\u0003e\u0004\"A\u0010>\n\u0005m|$a\u0005&zi\"|gnU2sSB$8+\u001a:wS\u000e,\u0017AD:de&\u0004HoU3sm&\u001cW\rI\u0001\tKZ,g\u000e\u001e\"vgV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aJ\u0001\u0007KZ,g\u000e^:\n\t\u0005%\u00111\u0001\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0005\u0005E\u0001\u0003BA\n\u0003/i!!!\u0006\u000b\u0005\t:\u0013\u0002BA\r\u0003+\u00111bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"\"#!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003[\ty#!\r\u00024A\u0011a\n\u0001\u0005\u0006\u000b2\u0001\rA\u0012\u0005\u0006\u00192\u0001\r!\u0014\u0005\u0006#2\u0001\rA\u0015\u0005\u0006+2\u0001\rA\u0016\u0015\u0006\u0003S\t7\u000e\u001c\u0005\u0006]2\u0001\ra\u001c\u0005\u0006o2\u0001\r!\u001f\u0005\u0006{2\u0001\ra \u0005\b\u0003\u001ba\u00019AA\t\u0003\u0019)\u00070[:ugR!\u0011\u0011HA !\r\u0001\u00141H\u0005\u0004\u0003{\t$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003j\u0001\u0019AA\"\u0003-!\u0017m\u001d5c_\u0006\u0014H-\u00133\u0011\t\u0005\u0015\u00131\u000b\b\u0005\u0003\u000f\ny\u0005E\u0002\u0002JEj!!a\u0013\u000b\u0007\u00055S&\u0001\u0004=e>|GOP\u0005\u0004\u0003#\n\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002V\u0005]#AB*ue&twMC\u0002\u0002REB3!DA.!\u0011\ti&!\u001c\u000e\u0005\u0005}#b\u00013\u0002b)!\u00111MA3\u0003\u0011\u0019wN]3\u000b\t\u0005\u001d\u0014\u0011N\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAA6\u0003\tIw.\u0003\u0003\u0002p\u0005}#!\u0002+j[\u0016$\u0017AB:fCJ\u001c\u0007\u000e\u0006\u0005\u0002v\u0005M\u0015qSAN!\u0019\t9(!!\u0002\b:!\u0011\u0011PA?\u001d\u0011\tI%a\u001f\n\u0003IJ1!a 2\u0003\u001d\u0001\u0018mY6bO\u0016LA!a!\u0002\u0006\n\u00191+Z9\u000b\u0007\u0005}\u0014\u0007\u0005\u0003\u0002\n\u0006=UBAAF\u0015\r\tiiI\u0001\u0007I>l\u0017-\u001b8\n\t\u0005E\u00151\u0012\u0002\n\t\u0006\u001c\bNY8be\u0012Dq!!&\u000f\u0001\u0004\t\u0019%\u0001\u0005qCJ,g\u000e^%e\u0011%\tIJ\u0004I\u0001\u0002\u0004\t\u0019%A\u0003uSRdW\rC\u0005\u0002\u001e:\u0001\n\u00111\u0001\u0002:\u0005\u0011RM\u001c4pe\u000e,\u0007+\u001a:nSN\u001c\u0018n\u001c8tQ\rq\u00111L\u0001\u0011g\u0016\f'o\u00195%I\u00164\u0017-\u001e7uII*\"!!*+\t\u0005\r\u0013qU\u0016\u0003\u0003S\u0003B!a+\u000246\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0005v]\u000eDWmY6fI*\u0011A-M\u0005\u0005\u0003k\u000biKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c]3be\u000eDG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m&\u0006BA\u001d\u0003O\u000b\u0011CZ5oI\u0012\u000b7\u000f\u001b2pCJ$')_%e)\u0011\t9)!1\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002D!\u001a\u0011#a\u0017\u0002\u001f\r\u0014X-\u0019;f\t\u0006\u001c\bNY8be\u0012$B!a\"\u0002J\"1AE\u0005a\u0001\u0003\u000fC3AEA.\u0003=)\b\u000fZ1uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BAD\u0003#Da\u0001J\nA\u0002\u0005\u001d\u0005fA\n\u0002\\\u0005yA-\u001a7fi\u0016$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0002Z\u0006}\u0007c\u0001\u0019\u0002\\&\u0019\u0011Q\\\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003\"\u0002\u0019AA\"Q\r!\u00121L\u0001\u0016O\u0016$H)Y:iE>\f'\u000f\u001a+f[Bd\u0017\r^3t)\u0011\t9/!@\u0011\r\u0005]\u0014\u0011QAu!\u0011\tY/!?\u000e\u0005\u00055(\u0002BAx\u0003c\fqA]3gY\u0016\u001cGO\u0003\u0003\u0002t\u0006U\u0018aA1qS*\u0019\u0011q_:\u0002\rAdWoZ5o\u0013\u0011\tY0!<\u0003\u0015\u0011+7o\u0019:jaR|'\u000fC\u0004\u0002\u0000V\u0001\rA!\u0001\u0002\u000bM\u001cw\u000e]3\u0011\t\u0005%%1A\u0005\u0005\u0005\u000b\tYIA\u0005US2,7kY8qK\"\u001aQ#a\u0017\u0002\u001f\u00154\u0018n\u0019;US2,7oQ1dQ\u0016$B!!7\u0003\u000e!1AE\u0006a\u0001\u0003\u000fC3AFA.\u0003I\u0001(o\u001c<jg&|g\u000eR1tQ\n|\u0017M\u001d3\u0015\t\u0005e'Q\u0003\u0005\u0007I]\u0001\r!a\"\u0002/A\u0014xN^5tS>tG)Y:iE>\f'\u000f\u001a+jY\u0016\u001cH\u0003BAm\u00057Aa\u0001\n\rA\u0002\u0005\u001d\u0015!\b3fG>\u0014\u0018\r^3XSRDWI\u001a4fGRLg/Z*fGV\u0014\u0018\u000e^=\u0015\t\u0005U$\u0011\u0005\u0005\b\u0005GI\u0002\u0019AA;\u0003)!\u0017m\u001d5c_\u0006\u0014Hm]\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011\u0011\u001cB\u0015\u0011\u0019!#\u00041\u0001\u0002\b\u0006\t2/\u001a;Po:,'/\u00134NSN\u001c\u0018N\\4\u0015\t\u0005e'q\u0006\u0005\u0007Im\u0001\r!a\"\u0002#\r,(O]3oiB\u0013\u0018N\\2ja\u0006d7/\u0006\u0002\u00036A1!q\u0007B\u001f\u0005\u0003j!A!\u000f\u000b\u0007\tm\u0012'\u0001\u0006d_2dWm\u0019;j_:LAAa\u0010\u0003:\tA\u0011\n^3sC\ndW\r\u0005\u0003\u0003D\t5SB\u0001B#\u0015\u0011\u00119E!\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0017\nAA[1wC&!\u0011Q\u000bB#\u00031\u0019WO\u001d:f]R\u0014v\u000e\\3t+\t\u0011\u0019\u0006\u0005\u0004\u0003V\tm#qL\u0007\u0003\u0005/RAA!\u0017\u0003:\u00059Q.\u001e;bE2,\u0017\u0002\u0002B/\u0005/\u0012aAQ;gM\u0016\u0014\bc\u00019\u0003b%\u0019!1M9\u0003\tI{G.Z\u0001\u0017Kb,7-\u001e;f!J|g/[:j_:\u001c6M]5qiR!\u0011q\u0011B5\u0011\u0019!c\u00041\u0001\u0002\b\u0006QR\r_3dkR,G+\u001b7f!J|g/[:j_:\u001c6M]5qiR1!q\u000eB;\u0005o\u0002B!!#\u0003r%!!1OAF\u0005\u0011!\u0016\u000e\\3\t\r\u0011z\u0002\u0019AAD\u0011\u001d\u0011Ih\ba\u0001\u0005_\nA\u0001^5mK\"\u001a\u0001A! \u0011\t\t}$QQ\u0007\u0003\u0005\u0003S1Aa![\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005\u000f\u0013\tIA\u0004TKJ4\u0018nY3")
public class DashboardService
implements Logging,
XlrJythonSupport {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    @Qualifier(value="tileCacheManager")
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public void executeScript(XlrScriptContext scriptContext) {
        XlrJythonSupport.executeScript$((XlrJythonSupport)this, (XlrScriptContext)scriptContext);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DashboardService dashboardService = this;
        synchronized (dashboardService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JythonScriptService scriptService() {
        return this.scriptService;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public boolean exists(String dashboardId) {
        return this.dashboardRepository.exists(dashboardId);
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title, boolean enforcePermissions) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles(), enforcePermissions));
    }

    public String search$default$2() {
        return null;
    }

    public boolean search$default$3() {
        return true;
    }

    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)new .colon.colon((Object)dashboard, (List)Nil$.MODULE$));
        return dashboard;
    }

    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardCreatedEvent(createdDashboard));
        this.dashboardSecurity.savePermissions(createdDashboard);
        return createdDashboard;
    }

    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboardTiles(dashboard);
        Dashboard originalDashboard = this.dashboardRepository.findDashboardById(dashboard.getId());
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)originalDashboard), (ConfigurationItem)dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardUpdatedEvent(updatedDashboard));
        this.dashboardSecurity.savePermissions(updatedDashboard);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)new .colon.colon((Object)updatedDashboard, (List)Nil$.MODULE$));
        return updatedDashboard;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        if (dashboardId.equals("Applications/DashboardHome")) {
            throw new PermissionDeniedException("Home dashboard can't be deleted");
        }
        this.dashboardSecurity.clearPermissions(dashboardId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
        this.eventBus().publish((XLReleaseEvent)new DashboardDeletedEvent(dashboard));
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala().map((Function1 & Serializable)x$1 -> x$1.getDescriptor())).filter((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.cacheManager.getCacheNames()).asScala().foreach((Function1 & Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public void provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        if (Strings.isNotBlank((String)dashboard.getScriptLocation())) {
            this.executeProvisionScript(dashboard);
            return;
        }
    }

    public void provisionDashboardTiles(Dashboard dashboard) {
        dashboard.setTiles(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(dashboard.getTiles()).asScala().map((Function1 & Serializable)x$3 -> this.executeTileProvisionScript(dashboard, (Tile)x$3))).asJava());
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate(CollectionConverters$.MODULE$.SeqHasAsJava(dashboards).asJava(), (DecoratorCache<DashboardSecurityDecoratorCache>)new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1()).getDecoratorCache(""));
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        if (!dashboard.isReleaseDashboard() && !dashboard.isHomeDashboard()) {
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
        if (dashboard.getAutoRefresh() && (dashboard.getAutoRefreshInterval() == null || Predef$.MODULE$.Integer2int(dashboard.getAutoRefreshInterval()) < 1)) {
            throw new Checks.IncorrectArgumentException("Auto refresh interval must be larger then 0", new Object[]{dashboard.getAutoRefreshInterval()});
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        if (!dashboard.hasOwner()) {
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
            return;
        }
    }

    private Iterable<String> currentPrincipals() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = DashboardScriptContext$.MODULE$.apply(dashboard);
            this.executeScript(scriptContext);
            return (Dashboard)scriptContext.getAttribute("dashboard");
        }
        return dashboard;
    }

    private Tile executeTileProvisionScript(Dashboard dashboard, Tile tile) {
        String scriptLocation = tile.getProvisioningScriptLocation();
        if (Ids.isNullId((String)tile.getId()) && Strings.isNotBlank((String)scriptLocation)) {
            XlrScriptContext scriptContext = DashboardScriptContext$.MODULE$.apply(dashboard, tile);
            this.executeScript(scriptContext);
            return (Tile)scriptContext.getAttribute("tile");
        }
        return tile;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(cache.asMap()).asScala().keys().filter((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, @Qualifier(value="tileCacheManager") CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
        Logging.$init$((Logging)this);
        XlrJythonSupport.$init$((XlrJythonSupport)this);
    }
}

