import React from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import './dashboard-cards.skeleton.less';

export const DashboardCardsSkeleton = () => {
    return (
        <div className="dashboard-cards-skeleton">
            <div className="dashboard-cards-skeleton-header">
                <DotSkeleton data-testid="title-skeleton" height={40} variant="rectangular" width={210} />
                <DotSkeleton data-testid="search-skeleton" height={40} variant="rectangular" width={220} />
            </div>
            <div className="dashboard-cards-skeleton-list">
                {[...Array(20)].map((_, index) => (
                    <DotSkeleton data-testid="card-skeleton" height={58} key={index} variant="rectangular" />
                ))}
            </div>
        </div>
    );
};
