import React from 'react';
import { DotButton } from '@digital-ai/dot-components';

import { ActionToolbarPortalContainer } from '../../../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';

interface DashboardListPortalProps {
    isButtonVisible: boolean;
    onButtonClick: () => void;
}

export const DashboardListPortal = ({ isButtonVisible, onButtonClick }: DashboardListPortalProps) => {
    return (
        <ActionToolbarPortalContainer helpLink="how-to/configure-custom-dashboards.html">
            {isButtonVisible && <DotButton onClick={onButtonClick}>Create custom dashboard</DotButton>}
        </ActionToolbarPortalContainer>
    );
};
