import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithTheme, preparePortalContainer, ReactWrapper } from '../../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { DashboardListPortal } from './dashboard-list.portal';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';

describe('DashboardListPortal', () => {
    let wrapper: ReactWrapper;
    const onClick = jest.fn();

    const getPortal = () => wrapper.find(ActionToolbarPortalContainer);
    const getAddButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props().children === 'Create custom dashboard');

    const mount = (isButtonVisible: boolean) => {
        wrapper = mountWithTheme(<DashboardListPortal isButtonVisible={isButtonVisible} onButtonClick={onClick} />);
    };

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should render properly if button is visible', () => {
        mount(true);
        expect(getPortal().props().helpLink).toBe('how-to/configure-custom-dashboards.html');
        const addButton = getAddButton();
        expect(addButton).toIncludeText('Create custom dashboard');
    });

    it('should render properly if button is not visible', () => {
        mount(false);
        expect(getAddButton()).not.toExist();
    });

    it('should handle onClick', () => {
        mount(true);
        getAddButton().invoke('onClick')?.();
        expect(onClick).toHaveBeenCalled();
    });
});
