package com.xebialabs.xlrelease.plugins.dashboard.actors.extension

import com.xebialabs.xlrelease.actors.ReleaseExecutionActor
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages.ExtensionCommand
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.plugins.dashboard.actors.extension.DashboardActorExtensionActorMessages.{CreateDashboard, UpdateDashboard, UpdateTile}
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}
import com.xebialabs.xlrelease.plugins.dashboard.repository.ReleaseDashboardRepository
import grizzled.slf4j.Logging
import org.apache.pekko.actor.Actor.Receive
import org.apache.pekko.actor.{Actor, ActorRef, ActorSystem}
import org.springframework.stereotype.Component

object DashboardActorExtensionActorMessages {

  case class CreateDashboard(dashboard: Dashboard) extends ExtensionCommand

  case class UpdateDashboard(dashboard: Dashboard) extends ExtensionCommand

  case class UpdateTile(tile: Tile) extends ExtensionCommand

}

@Component
class DashboardActorExtensionHandlerFactory(val actorSystem: ActorSystem, dashboardRepository: ReleaseDashboardRepository)
  extends ActorExtensionHandlerFactory
    with Logging {

  override def getHandler(self: ActorRef, sender: () => ActorRef, release: => Release): Receive = {
    case CreateDashboard(dashboard: Dashboard) => replyOrFail(sender) {
      dashboardRepository.createDashboard(dashboard)
    }
    case UpdateDashboard(dashboard: Dashboard) => replyOrFail(sender) {
      dashboardRepository.updateDashboard(dashboard)
    }
    case UpdateTile(tile: Tile) => replyOrFail(sender) {
      dashboardRepository.updateTile(tile)
    }

  }

  override def supports(clazz: Class[_ <: Actor]): Boolean = classOf[ReleaseExecutionActor].isAssignableFrom(clazz)
}
