import { globalDashboard, initialState } from './global-dashboard.reducer';
import { Dashboard } from '../types';

const { executeDashboardAction, setGlobalDashboards, loadGlobalDashboards, setCreateDashboardPermission, searchWithFilter, setGlobalFilter, setLoading } =
    globalDashboard.actions;

describe('globalDashboard reducer', () => {
    it('should have initial state', () => {
        expect(globalDashboard.name).toBe('globalDashboard');
        // if a new reducer is added, this test should fail and dev must fix and add new one
        expect(Object.keys(globalDashboard.actions)).toStrictEqual([
            'loadGlobalDashboards',
            'setGlobalDashboards',
            'setCreateDashboardPermission',
            'executeDashboardAction',
            'searchWithFilter',
            'setGlobalFilter',
            'setLoading',
        ]);
        expect(globalDashboard.reducer(undefined, { type: 'default' })).toMatchObject(initialState);
    });

    describe('reducers', () => {
        const dashboard = { id: 'MyId', title: 'My title' } as Dashboard;

        describe('loadGlobalDashboards', () => {
            it('should do nothing with the state', () => {
                const state = globalDashboard.reducer(initialState, loadGlobalDashboards({ title: 'filter' }));
                expect(state).toMatchObject(initialState);
            });
        });
        describe('setGlobalDashboards', () => {
            it('should update state', () => {
                const state = globalDashboard.reducer(initialState, setGlobalDashboards([dashboard]));
                expect(state.dashboards).toStrictEqual([dashboard]);
            });
        });
        describe('setCreateDashboardPermission', () => {
            it('should update state', () => {
                const state = globalDashboard.reducer(initialState, setCreateDashboardPermission(true));
                expect(state.hasCreateDashboardPermission).toStrictEqual(true);
            });
        });
        describe('executeDashboardAction', () => {
            it('should do nothing with the state', () => {
                const state = globalDashboard.reducer(initialState, executeDashboardAction({ actionId: 'DELETE', dashboard }));
                expect(state).toMatchObject(initialState);
            });
        });
        describe('searchWithFilter', () => {
            it('should do nothing with the state', () => {
                const state = globalDashboard.reducer(initialState, searchWithFilter('filter'));
                expect(state).toMatchObject(initialState);
            });
        });
        describe('setGlobalFilter', () => {
            it('should do nothing with the state', () => {
                const state = globalDashboard.reducer(initialState, setGlobalFilter('filter'));
                expect(state.titleFilter).toBe('filter');
            });
        });

        describe('setLoading', () => {
            it('should update loading state', () => {
                const state = globalDashboard.reducer(initialState, setLoading(false));
                expect(state.loading).toBe(false);
            });
        });
    });
});
