package com.xebialabs.xlrelease.plugins.dashboard.views

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.databind.ObjectMapper
import com.xebialabs.deployit.booter.local.utils.Strings.isBlank
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.internal.InternalMetadata
import com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT
import com.xebialabs.xlrelease.plugins.dashboard.builder.DashboardBuilder.newDashboard
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import com.xebialabs.xlrelease.plugins.dashboard.views.TileView.toTile
import com.xebialabs.xlrelease.repository.ConfigurationRepository

import java.util
import java.util.{List => JList, Map => JMap}
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

object DashboardView {
  def apply(dashboard: Dashboard) = new DashboardView(dashboard)

  def toDashboard(dashboardView: DashboardView)(implicit configurationRepository: ConfigurationRepository, objectMapper: ObjectMapper): Dashboard = {
    val templateType = if (isBlank(dashboardView.templateType)) Type.valueOf(classOf[Dashboard]) else Type.valueOf(dashboardView.templateType)
    newDashboard
      .withId(dashboardView.getId)
      .withTemplateType(templateType)
      .withTitle(dashboardView.getTitle)
      .withDescription(dashboardView.getDescription)
      .withParentId(dashboardView.getParentId)
      .withColumns(dashboardView.getColumns)
      .withOwner(dashboardView.getOwner)
      .withViewers(dashboardView.roleViewers.asScala.toSeq: _*)
      .withEditors(dashboardView.roleEditors.asScala.toSeq: _*)
      .withTiles(dashboardView.getTiles.asScala.map(toTile).toSeq: _*)
      .withAutoRefresh(dashboardView.getAutoRefresh)
      .withAutoRefreshInterval(dashboardView.getAutoRefreshInterval)
      .withProperties(dashboardView.getProperties.asScala.map { case (name, value) => convertValue(templateType.getDescriptor, name, value) }.toMap)
      .build
  }
}

@JsonIgnoreProperties(ignoreUnknown = true)
class DashboardView(val dashboard: Dashboard) {

  @BeanProperty
  var id: String = dashboard.getId

  @BeanProperty
  var templateType: String = dashboard.getType.toString

  @BeanProperty
  var title: String = dashboard.getTitle

  @BeanProperty
  var rows: Integer = dashboard.getRows

  @BeanProperty
  var columns: Integer = dashboard.getColumns

  @BeanProperty
  var description: String = dashboard.getDescription

  @BeanProperty
  var parentId: String = dashboard.getParentId

  @BeanProperty
  var owner: String = dashboard.getOwner

  @BeanProperty
  var tiles: JList[TileView] = dashboard.getTiles.asScala.map(TileView.apply).asJava

  @BeanProperty
  var roleViewers: JList[String] = dashboard.getRoleViewers

  @BeanProperty
  var roleEditors: JList[String] = dashboard.getRoleEditors

  @BeanProperty
  var autoRefresh: Boolean = dashboard.getAutoRefresh

  @BeanProperty
  var autoRefreshInterval: Integer = dashboard.getAutoRefreshInterval

  @BeanProperty
  var properties: JMap[String, AnyRef] = {
    dashboard.getType.getDescriptor.getPropertyDescriptors.asScala
      .filter(_.getCategory == CATEGORY_INPUT)
      .map(p => (p.getName, p.get(dashboard)))
      .toMap.asJava
  }

  @BeanProperty
  var metadata: util.Map[String, InternalMetadata] = dashboard.get$metadata()

  def this() = {
    this(newDashboard.build)
  }
}
