import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithTheme, preparePortalContainer, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { ActionToolbarPortalContainer } from '@xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { AddDashboardPagePortal } from './add-dashboard-page-portal';

describe('AddDashboardPagePortal', () => {
    let wrapper: ReactWrapper;

    const getPortal = () => wrapper.find(ActionToolbarPortalContainer);
    const getCancelButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props().children === 'Cancel');

    const mount = (folderId?: string) => {
        wrapper = mountWithTheme(<AddDashboardPagePortal folderId={folderId} />);
    };

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should render properly', () => {
        mount();
        expect(getPortal().props().helpLink).toBe('how-to/configure-custom-dashboards');
        expect(getCancelButton().props().type).toBe('outlined');
        expect(getCancelButton()).toIncludeText('Cancel');
    });

    it('should handle cancel without folderId', () => {
        mount();
        getCancelButton().invoke('onClick')?.();
        expect(window.location.href).toBe('http://localhost/#/dashboards/list');
    });
    it('should handle cancel with folderId', () => {
        mount('Applications/Folder1');
        getCancelButton().invoke('onClick')?.();
        expect(window.location.href).toBe('http://localhost/#/folders/Applications/Folder1/dashboards');
    });
});
