/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\neCND'm\\1sIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005Q!/\u001a9pg&$xN]=\n\u0005uQ\"!\b#fY\u0016<\u0017\r^5oO\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\tECND'm\\1sIN+7-\u001e:jifD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u001bI\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLH)Z2pe\u0006$xN\u001d\t\u0003C\u001dJ!\u0001\u000b\u0002\u00035\u0011\u000b7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010R3d_J\fGo\u001c:\t\u0011)\u0002!\u0011!Q\u0001\n-\n1B]8mKN+'O^5dKB\u0011A&M\u0007\u0002[)\u0011afL\u0001\tg\u0016\u001cWO]5us*\u0011\u0001GC\u0001\tI\u0016\u0004Hn\\=ji&\u0011!'\f\u0002\f%>dWmU3sm&\u001cW\rC\u00035\u0001\u0011\u0005Q'\u0001\u0004=S:LGO\u0010\u000b\u0006m]B\u0014H\u000f\t\u0003C\u0001AQaF\u001aA\u0002aAQaH\u001aA\u0002\u0001BQ!J\u001aA\u0002\u0019BQAK\u001aA\u0002-B#a\r\u001f\u0011\u0005uBU\"\u0001 \u000b\u0005}\u0002\u0015AC1o]>$\u0018\r^5p]*\u0011\u0011IQ\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0019E)A\u0003cK\u0006t7O\u0003\u0002F\r\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001H\u0003\ry'oZ\u0005\u0003\u0013z\u0012\u0011\"Q;u_^L'/\u001a3\t\u000b-\u0003A\u0011\u0001'\u0002\rM,\u0017M]2i)\riu,\u001b\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011f\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0011QKE\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!\u0016\n\u0011\u0005ikV\"A.\u000b\u0005q#\u0011A\u00023p[\u0006Lg.\u0003\u0002_7\nIA)Y:iE>\f'\u000f\u001a\u0005\u0006A*\u0003\r!Y\u0001\ta\u0006\u0014XM\u001c;JIB\u0011!M\u001a\b\u0003G\u0012\u0004\"\u0001\u0015\n\n\u0005\u0015\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a\n\t\u000b)T\u0005\u0019A1\u0002\u000bQLG\u000f\\3)\u0005)c\u0007CA7t\u001b\u0005q'BA p\u0015\t\u0001\u0018/A\u0004nKR\u0014\u0018nY:\u000b\u0005Id\u0011\u0001C2pI\u0006D\u0017\r\\3\n\u0005Qt'!\u0002+j[\u0016$\u0007\"\u0002<\u0001\t\u00039\u0018!\u00054j]\u0012$\u0015m\u001d5c_\u0006\u0014HMQ=JIR\u0011\u0011\f\u001f\u0005\u0006sV\u0004\r!Y\u0001\fI\u0006\u001c\bNY8be\u0012LE\r\u000b\u0002vY\")A\u0010\u0001C\u0001{\u0006y1M]3bi\u0016$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0002Z}\")Qa\u001fa\u00013\"\u00121\u0010\u001c\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003=)\b\u000fZ1uK\u0012\u000b7\u000f\u001b2pCJ$GcA-\u0002\b!1Q!!\u0001A\u0002eC3!!\u0001m\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\tq\u0002Z3mKR,G)Y:iE>\f'\u000f\u001a\u000b\u0005\u0003#\t9\u0002E\u0002\u0012\u0003'I1!!\u0006\u0013\u0005\u0011)f.\u001b;\t\re\fY\u00011\u0001bQ\r\tY\u0001\u001c\u0005\b\u0003;\u0001A\u0011CA\u0010\u0003u!WmY8sCR,w+\u001b;i\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sSRLHcA'\u0002\"!9\u00111EA\u000e\u0001\u0004i\u0015A\u00033bg\"\u0014w.\u0019:eg\"9\u0011q\u0005\u0001\u0005\n\u0005%\u0012\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005E\u00111\u0006\u0005\u0007\u000b\u0005\u0015\u0002\u0019A-\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\u0005\t2/\u001a;Po:,'/\u00134NSN\u001c\u0018N\\4\u0015\t\u0005E\u00111\u0007\u0005\u0007\u000b\u00055\u0002\u0019A-\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005\t2-\u001e:sK:$\bK]5oG&\u0004\u0018\r\\:\u0016\u0005\u0005m\u0002CBA\u001f\u0003\u0007\n9%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0005}\"\u0001C%uKJ\f'\r\\3\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005!A.\u00198h\u0015\t\t\t&\u0001\u0003kCZ\f\u0017bA4\u0002L!9\u0011q\u000b\u0001\u0005\n\u0005e\u0013\u0001D2veJ,g\u000e\u001e*pY\u0016\u001cXCAA.!\u0019\ti&a\u0019\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\ny$A\u0004nkR\f'\r\\3\n\t\u0005\u0015\u0014q\f\u0002\u0007\u0005V4g-\u001a:\u0011\u00071\nI'C\u0002\u0002l5\u0012AAU8mK\"\u001a\u0001!a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001eE\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003s\n\u0019HA\u0004TKJ4\u0018nY3")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final RoleService roleService;

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardRepository.deleteDashboard(dashboardId);
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, RoleService roleService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.roleService = roleService;
    }
}

