/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\neCND'm\\1sIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005Q!/\u001a9pg&$xN]=\n\u0005uQ\"!\b#fY\u0016<\u0017\r^5oO\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\tECND'm\\1sIN+7-\u001e:jifD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u001bI\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLH)Z2pe\u0006$xN\u001d\t\u0003C\u001dJ!\u0001\u000b\u0002\u00035\u0011\u000b7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010R3d_J\fGo\u001c:\t\u0011)\u0002!\u0011!Q\u0001\n-\n1B]8mKN+'O^5dKB\u0011A&M\u0007\u0002[)\u0011afL\u0001\tg\u0016\u001cWO]5us*\u0011\u0001GC\u0001\tI\u0016\u0004Hn\\=ji&\u0011!'\f\u0002\f%>dWmU3sm&\u001cW\rC\u00035\u0001\u0011\u0005Q'\u0001\u0004=S:LGO\u0010\u000b\u0006m]B\u0014H\u000f\t\u0003C\u0001AQaF\u001aA\u0002aAQaH\u001aA\u0002\u0001BQ!J\u001aA\u0002\u0019BQAK\u001aA\u0002-B#a\r\u001f\u0011\u0005uBU\"\u0001 \u000b\u0005}\u0002\u0015AC1o]>$\u0018\r^5p]*\u0011\u0011IQ\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0019E)A\u0003cK\u0006t7O\u0003\u0002F\r\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001H\u0003\ry'oZ\u0005\u0003\u0013z\u0012\u0011\"Q;u_^L'/\u001a3\t\u000b-\u0003A\u0011\u0001'\u0002\rM,\u0017M]2i)\riu,\u001b\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011f\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0011QKE\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!\u0016\n\u0011\u0005ikV\"A.\u000b\u0005q#\u0011A\u00023p[\u0006Lg.\u0003\u0002_7\nIA)Y:iE>\f'\u000f\u001a\u0005\u0006A*\u0003\r!Y\u0001\ta\u0006\u0014XM\u001c;JIB\u0011!M\u001a\b\u0003G\u0012\u0004\"\u0001\u0015\n\n\u0005\u0015\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a\n\t\u000f)T\u0005\u0013!a\u0001C\u0006)A/\u001b;mK\"\u0012!\n\u001c\t\u0003[Nl\u0011A\u001c\u0006\u0003\u007f=T!\u0001]9\u0002\u000f5,GO]5dg*\u0011!\u000fD\u0001\tG>$\u0017\r[1mK&\u0011AO\u001c\u0002\u0006)&lW\r\u001a\u0005\u0006m\u0002!\ta^\u0001\u0012M&tG\rR1tQ\n|\u0017M\u001d3Cs&#GCA-y\u0011\u0015IX\u000f1\u0001b\u0003-!\u0017m\u001d5c_\u0006\u0014H-\u00133)\u0005Ud\u0007\"\u0002?\u0001\t\u0003i\u0018aD2sK\u0006$X\rR1tQ\n|\u0017M\u001d3\u0015\u0005es\b\"B\u0003|\u0001\u0004I\u0006FA>m\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tq\"\u001e9eCR,G)Y:iE>\f'\u000f\u001a\u000b\u00043\u0006\u001d\u0001BB\u0003\u0002\u0002\u0001\u0007\u0011\fK\u0002\u0002\u00021Dq!!\u0004\u0001\t\u0003\ty!A\beK2,G/\u001a#bg\"\u0014w.\u0019:e)\u0011\t\t\"a\u0006\u0011\u0007E\t\u0019\"C\u0002\u0002\u0016I\u0011A!\u00168ji\"1\u00110a\u0003A\u0002\u0005D3!a\u0003m\u0011\u001d\ti\u0002\u0001C\t\u0003?\tQ\u0004Z3d_J\fG/Z,ji\",eMZ3di&4XmU3dkJLG/\u001f\u000b\u0004\u001b\u0006\u0005\u0002bBA\u0012\u00037\u0001\r!T\u0001\u000bI\u0006\u001c\bNY8be\u0012\u001c\bbBA\u0014\u0001\u0011%\u0011\u0011F\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011\u0011CA\u0016\u0011\u0019)\u0011Q\u0005a\u00013\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012!E:fi>;h.\u001a:JM6K7o]5oOR!\u0011\u0011CA\u001a\u0011\u0019)\u0011Q\u0006a\u00013\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0012!E2veJ,g\u000e\u001e)sS:\u001c\u0017\u000e]1mgV\u0011\u00111\b\t\u0007\u0003{\t\u0019%a\u0012\u000e\u0005\u0005}\"bAA!%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0013q\b\u0002\t\u0013R,'/\u00192mKB!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001\u00027b]\u001eT!!!\u0015\u0002\t)\fg/Y\u0005\u0004O\u0006-\u0003bBA,\u0001\u0011%\u0011\u0011L\u0001\rGV\u0014(/\u001a8u%>dWm]\u000b\u0003\u00037\u0002b!!\u0018\u0002d\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0010\u0002\u000f5,H/\u00192mK&!\u0011QMA0\u0005\u0019\u0011UO\u001a4feB\u0019A&!\u001b\n\u0007\u0005-TF\u0001\u0003S_2,\u0007\"CA8\u0001E\u0005I\u0011AA9\u0003A\u0019X-\u0019:dQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0002t)\u001a\u0011-!\u001e,\u0005\u0005]\u0004\u0003BA=\u0003\u0003k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0010\n\n\t\u0005\r\u00151\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007f\u0001\u0001\u0002\bB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e\u0012\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t*a#\u0003\u000fM+'O^5dK\u0002")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final RoleService roleService;

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardRepository.deleteDashboard(dashboardId);
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, RoleService roleService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.roleService = roleService;
    }
}

