/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\neCND'm\\1sIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005Q!/\u001a9pg&$xN]=\n\u0005uQ\"!\b#fY\u0016<\u0017\r^5oO\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\tECND'm\\1sIN+7-\u001e:jifD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u001bI\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLH)Z2pe\u0006$xN\u001d\t\u0003C\u001dJ!\u0001\u000b\u0002\u00035\u0011\u000b7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010R3d_J\fGo\u001c:\t\u0011)\u0002!\u0011!Q\u0001\n-\n1B]8mKN+'O^5dKB\u0011A&M\u0007\u0002[)\u0011afL\u0001\tg\u0016\u001cWO]5us*\u0011\u0001GC\u0001\tI\u0016\u0004Hn\\=ji&\u0011!'\f\u0002\f%>dWmU3sm&\u001cW\r\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u00035\u00198M]5qiN+'O^5dKB\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0007Uf$\bn\u001c8\u000b\u0005iB\u0011AB:de&\u0004H/\u0003\u0002=o\t\u0019\"*\u001f;i_:\u001c6M]5qiN+'O^5dK\"Aa\b\u0001BC\u0002\u0013\rq(A\u0006dS&#7+\u001a:wS\u000e,W#\u0001!\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005\rA\u0011B\u0001#C\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u0001\u000bAbY5JIN+'O^5dK\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtDc\u0002&L\u00196su\n\u0015\t\u0003C\u0001AQaF$A\u0002aAQaH$A\u0002\u0001BQ!J$A\u0002\u0019BQAK$A\u0002-BQ\u0001N$A\u0002UBQAP$A\u0004\u0001C#a\u0012*\u0011\u0005MsV\"\u0001+\u000b\u0005U3\u0016AC1o]>$\u0018\r^5p]*\u0011q\u000bW\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI&,A\u0003cK\u0006t7O\u0003\u0002\\9\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001^\u0003\ry'oZ\u0005\u0003?R\u0013\u0011\"Q;u_^L'/\u001a3\t\u000b\u0005\u0004A\u0011\u00012\u0002\rM,\u0017M]2i)\r\u0019Wo \t\u0004I2|gBA3k\u001d\t1\u0017.D\u0001h\u0015\tAg\"\u0001\u0004=e>|GOP\u0005\u0002'%\u00111NE\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0002TKFT!a\u001b\n\u0011\u0005A\u001cX\"A9\u000b\u0005I$\u0011A\u00023p[\u0006Lg.\u0003\u0002uc\nIA)Y:iE>\f'\u000f\u001a\u0005\u0006m\u0002\u0004\ra^\u0001\ta\u0006\u0014XM\u001c;JIB\u0011\u0001\u0010 \b\u0003sj\u0004\"A\u001a\n\n\u0005m\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\n\t\u0011\u0005\u0005\u0001\r%AA\u0002]\fQ\u0001^5uY\u0016D3\u0001YA\u0003!\u0011\t9!a\u0005\u000e\u0005\u0005%!bA+\u0002\f)!\u0011QBA\b\u0003\u001diW\r\u001e:jGNT1!!\u0005\r\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u000b\u0003\u0013\u0011Q\u0001V5nK\u0012Dq!!\u0007\u0001\t\u0003\tY\"A\tgS:$G)Y:iE>\f'\u000f\u001a\"z\u0013\u0012$2a\\A\u000f\u0011\u001d\ty\"a\u0006A\u0002]\f1\u0002Z1tQ\n|\u0017M\u001d3JI\"\"\u0011qCA\u0003\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tqb\u0019:fCR,G)Y:iE>\f'\u000f\u001a\u000b\u0004_\u0006%\u0002BB\u0003\u0002$\u0001\u0007q\u000e\u000b\u0003\u0002$\u0005\u0015\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\u0010kB$\u0017\r^3ECND'm\\1sIR\u0019q.a\r\t\r\u0015\ti\u00031\u0001pQ\u0011\ti#!\u0002\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<\u0005yA-\u001a7fi\u0016$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0002>\u0005\r\u0003cA\t\u0002@%\u0019\u0011\u0011\t\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003?\t9\u00041\u0001xQ\u0011\t9$!\u0002\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005)r-\u001a;ECND'm\\1sIR+W\u000e\u001d7bi\u0016\u001cH\u0003BA'\u0003G\u0002B\u0001\u001a7\u0002PA!\u0011\u0011KA0\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013a\u0002:fM2,7\r\u001e\u0006\u0005\u00033\nY&A\u0002ba&T1!!\u00180\u0003\u0019\u0001H.^4j]&!\u0011\u0011MA*\u0005)!Um]2sSB$xN\u001d\u0005\t\u0003K\n9\u00051\u0001\u0002h\u0005)1oY8qKB\u0019\u0001/!\u001b\n\u0007\u0005-\u0014OA\u0005US2,7kY8qK\"\"\u0011qIA\u0003\u0011\u001d\t\t\b\u0001C\t\u0003g\nQ\u0004Z3d_J\fG/Z,ji\",eMZ3di&4XmU3dkJLG/\u001f\u000b\u0004G\u0006U\u0004bBA<\u0003_\u0002\raY\u0001\u000bI\u0006\u001c\bNY8be\u0012\u001c\bbBA>\u0001\u0011%\u0011QP\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011QHA@\u0011\u0019)\u0011\u0011\u0010a\u0001_\"9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0015!E:fi>;h.\u001a:JM6K7o]5oOR!\u0011QHAD\u0011\u0019)\u0011\u0011\u0011a\u0001_\"9\u00111\u0012\u0001\u0005\n\u00055\u0015!E2veJ,g\u000e\u001e)sS:\u001c\u0017\u000e]1mgV\u0011\u0011q\u0012\t\u0007\u0003#\u000b9*a'\u000e\u0005\u0005M%bAAK%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00151\u0013\u0002\t\u0013R,'/\u00192mKB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016\u0001\u00027b]\u001eT!!!*\u0002\t)\fg/Y\u0005\u0004{\u0006}\u0005bBAV\u0001\u0011%\u0011QV\u0001\rGV\u0014(/\u001a8u%>dWm]\u000b\u0003\u0003_\u0003b!!-\u00028\u0006mVBAAZ\u0015\u0011\t),a%\u0002\u000f5,H/\u00192mK&!\u0011\u0011XAZ\u0005\u0019\u0011UO\u001a4feB\u0019A&!0\n\u0007\u0005}VF\u0001\u0003S_2,\u0007bBAb\u0001\u0011%\u0011QY\u0001\u0013aJ|g/[:j_:$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0002H\u00065\u0007cA\t\u0002J&\u0019\u00111\u001a\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0006\u0003\u0003\u0004\ra\u001c\u0005\b\u0003#\u0004A\u0011BAj\u0003Y)\u00070Z2vi\u0016\u0004&o\u001c<jg&|gnU2sSB$HcA8\u0002V\"1Q!a4A\u0002=Dq!!7\u0001\t\u0013\tY.A\nde\u0016\fG/Z*de&\u0004HoQ8oi\u0016DH\u000f\u0006\u0003\u0002^\u0006\u0015\b\u0003BAp\u0003Cl\u0011!O\u0005\u0004\u0003GL$\u0001\u0005-meN\u001b'/\u001b9u\u0007>tG/\u001a=u\u0011\u0019)\u0011q\u001ba\u0001_\"I\u0011\u0011\u001e\u0001\u0012\u0002\u0013\u0005\u00111^\u0001\u0011g\u0016\f'o\u00195%I\u00164\u0017-\u001e7uII*\"!!<+\u0007]\fyo\u000b\u0002\u0002rB!\u00111_A~\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018!C;oG\",7m[3e\u0015\t)&#\u0003\u0003\u0002~\u0006U(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u001a\u0001A!\u0001\u0011\t\t\r!\u0011B\u0007\u0003\u0005\u000bQ1Aa\u0002[\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005\u0017\u0011)AA\u0004TKJ4\u0018nY3")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final CiIdService ciIdService;

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, RoleService roleService, JythonScriptService scriptService, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.ciIdService = ciIdService;
    }
}

