/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\neCND'm\\1sIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005Q!/\u001a9pg&$xN]=\n\u0005uQ\"!\b#fY\u0016<\u0017\r^5oO\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\tECND'm\\1sIN+7-\u001e:jifD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u001bI\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLH)Z2pe\u0006$xN\u001d\t\u0003C\u001dJ!\u0001\u000b\u0002\u00035\u0011\u000b7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010R3d_J\fGo\u001c:\t\u0011)\u0002!\u0011!Q\u0001\n-\nAbY1dQ\u0016l\u0015M\\1hKJ\u0004\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\u000b\r\f7\r[3\u000b\u0005A\n\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003I\n1a\u001c:h\u0013\t!TF\u0001\u0007DC\u000eDW-T1oC\u001e,'\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005qR\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005yJ$a\u0003*pY\u0016\u001cVM\u001d<jG\u0016D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000eg\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015A\u00026zi\"|gN\u0003\u0002G\u0011\u000511o\u0019:jaRL!\u0001S\"\u0003')KH\u000f[8o'\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\t\u0011)\u0003!Q1A\u0005\u0004-\u000b1bY5JIN+'O^5dKV\tA\n\u0005\u0002N\u001f6\taJ\u0003\u0002\u0004\u0011%\u0011\u0001K\u0014\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003M\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019a\u0014N\\5u}QAak\u0016-Z5ncV\f\u0005\u0002\"\u0001!)qc\u0015a\u00011!)qd\u0015a\u0001A!)Qe\u0015a\u0001M!)!f\u0015a\u0001W!)ag\u0015a\u0001o!)\u0001i\u0015a\u0001\u0003\")!j\u0015a\u0002\u0019\"\u00121k\u0018\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\f!\"\u00198o_R\fG/[8o\u0015\t!W-A\u0004gC\u000e$xN]=\u000b\u0005\u0019|\u0013!\u00022fC:\u001c\u0018B\u00015b\u0005%\tU\u000f^8xSJ,G\rC\u0003k\u0001\u0011\u00051.\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0005Yz\f\t\u0002E\u0002nkbt!A\\:\u000f\u0005=\u0014X\"\u00019\u000b\u0005Et\u0011A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t!(#A\u0004qC\u000e\\\u0017mZ3\n\u0005Y<(aA*fc*\u0011AO\u0005\t\u0003srl\u0011A\u001f\u0006\u0003w\u0012\ta\u0001Z8nC&t\u0017BA?{\u0005%!\u0015m\u001d5c_\u0006\u0014H\r\u0003\u0004\u0000S\u0002\u0007\u0011\u0011A\u0001\ta\u0006\u0014XM\u001c;JIB!\u00111AA\u0006\u001d\u0011\t)!a\u0002\u0011\u0005=\u0014\u0012bAA\u0005%\u00051\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u0003\u0013\u0011%\t\u0019\"\u001bI\u0001\u0002\u0004\t\t!A\u0003uSRdW\rK\u0002j\u0003/\u0001B!!\u0007\u0002&5\u0011\u00111\u0004\u0006\u0004E\u0006u!\u0002BA\u0010\u0003C\tq!\\3ue&\u001c7OC\u0002\u0002$1\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003O\tYBA\u0003US6,G\rC\u0004\u0002,\u0001!\t!!\f\u0002#\u0019Lg\u000e\u001a#bg\"\u0014w.\u0019:e\u0005fLE\rF\u0002y\u0003_A\u0001\"!\r\u0002*\u0001\u0007\u0011\u0011A\u0001\fI\u0006\u001c\bNY8be\u0012LE\r\u000b\u0003\u0002*\u0005]\u0001bBA\u001c\u0001\u0011\u0005\u0011\u0011H\u0001\u0010GJ,\u0017\r^3ECND'm\\1sIR\u0019\u00010a\u000f\t\r\u0015\t)\u00041\u0001yQ\u0011\t)$a\u0006\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D\u0005yQ\u000f\u001d3bi\u0016$\u0015m\u001d5c_\u0006\u0014H\rF\u0002y\u0003\u000bBa!BA \u0001\u0004A\b\u0006BA \u0003/Aq!a\u0013\u0001\t\u0003\ti%A\beK2,G/\u001a#bg\"\u0014w.\u0019:e)\u0011\ty%!\u0016\u0011\u0007E\t\t&C\u0002\u0002TI\u0011A!\u00168ji\"A\u0011\u0011GA%\u0001\u0004\t\t\u0001\u000b\u0003\u0002J\u0005]\u0001bBA.\u0001\u0011\u0005\u0011QL\u0001\u0016O\u0016$H)Y:iE>\f'\u000f\u001a+f[Bd\u0017\r^3t)\u0011\ty&!\u001e\u0011\t5,\u0018\u0011\r\t\u0005\u0003G\n\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003\u001d\u0011XM\u001a7fGRTA!a\u001b\u0002n\u0005\u0019\u0011\r]5\u000b\u0007\u0005=4(\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0003g\n)G\u0001\u0006EKN\u001c'/\u001b9u_JD\u0001\"a\u001e\u0002Z\u0001\u0007\u0011\u0011P\u0001\u0006g\u000e|\u0007/\u001a\t\u0004s\u0006m\u0014bAA?u\nIA+\u001b7f'\u000e|\u0007/\u001a\u0015\u0005\u00033\n9\u0002C\u0004\u0002\u0004\u0002!\t!!\"\u0002\u001f\u00154\u0018n\u0019;US2,7oQ1dQ\u0016$B!a\u0014\u0002\b\"1Q!!!A\u0002aDC!!!\u0002\u0018!9\u0011Q\u0012\u0001\u0005\u0012\u0005=\u0015!\b3fG>\u0014\u0018\r^3XSRDWI\u001a4fGRLg/Z*fGV\u0014\u0018\u000e^=\u0015\u00071\f\t\nC\u0004\u0002\u0014\u0006-\u0005\u0019\u00017\u0002\u0015\u0011\f7\u000f\u001b2pCJ$7\u000fC\u0004\u0002\u0018\u0002!I!!'\u0002\u0011Y\fG.\u001b3bi\u0016$B!a\u0014\u0002\u001c\"1Q!!&A\u0002aDq!a(\u0001\t\u0013\t\t+A\ttKR|uO\\3s\u0013\u001al\u0015n]:j]\u001e$B!a\u0014\u0002$\"1Q!!(A\u0002aDq!a*\u0001\t\u0013\tI+A\tdkJ\u0014XM\u001c;Qe&t7-\u001b9bYN,\"!a+\u0011\r\u00055\u00161WA\\\u001b\t\tyKC\u0002\u00022J\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t),a,\u0003\u0011%#XM]1cY\u0016\u0004B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003mC:<'BAAa\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0018\u0005\b\u0003\u000f\u0004A\u0011BAe\u00031\u0019WO\u001d:f]R\u0014v\u000e\\3t+\t\tY\r\u0005\u0004\u0002N\u0006M\u0017q[\u0007\u0003\u0003\u001fTA!!5\u00020\u00069Q.\u001e;bE2,\u0017\u0002BAk\u0003\u001f\u0014aAQ;gM\u0016\u0014\bc\u0001\u001d\u0002Z&\u0019\u00111\\\u001d\u0003\tI{G.\u001a\u0005\b\u0003?\u0004A\u0011BAq\u0003I\u0001(o\u001c<jg&|g\u000eR1tQ\n|\u0017M\u001d3\u0015\t\u0005\r\u0018\u0011\u001e\t\u0004#\u0005\u0015\u0018bAAt%\t\u0019\u0011I\\=\t\r\u0015\ti\u000e1\u0001y\u0011\u001d\ti\u000f\u0001C\u0005\u0003_\fa#\u001a=fGV$X\r\u0015:pm&\u001c\u0018n\u001c8TGJL\u0007\u000f\u001e\u000b\u0004q\u0006E\bBB\u0003\u0002l\u0002\u0007\u0001\u0010C\u0004\u0002v\u0002!I!a>\u0002'\r\u0014X-\u0019;f'\u000e\u0014\u0018\u000e\u001d;D_:$X\r\u001f;\u0015\t\u0005e(\u0011\u0001\t\u0005\u0003w\fi0D\u0001F\u0013\r\ty0\u0012\u0002\u001112\u00148k\u0019:jaR\u001cuN\u001c;fqRDa!BAz\u0001\u0004A\b\"\u0003B\u0003\u0001E\u0005I\u0011\u0001B\u0004\u0003A\u0019X-\u0019:dQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\n)\"\u0011\u0011\u0001B\u0006W\t\u0011i\u0001\u0005\u0003\u0003\u0010\t]QB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u0013Ut7\r[3dW\u0016$'B\u00012\u0013\u0013\u0011\u0011IB!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u0002\u0001\u0005;\u0001BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0004\u0005Gy\u0013AC:uKJ,w\u000e^=qK&!!q\u0005B\u0011\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final CiIdService ciIdService;

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.ciIdService = ciIdService;
    }
}

