/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardCreatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardDeletedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardUpdatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001\u0002\u000f\u001e\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tO\u0002\u0011)\u0019!C\u0002Q\"Aa\u000e\u0001B\u0001B\u0003%\u0011\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004\u0002\f\u0001!\t!!\u0004\t\u0013\u0005}\u0003!%A\u0005\u0002\u0005\u0005\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"9\u00111\u001a\u0001\u0005\u0012\u00055\u0007bBAj\u0001\u0011%\u0011Q\u001b\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u0014\u0001!IA!\u0006\t\u000f\t}\u0001\u0001\"\u0003\u0003\"!9!Q\u0005\u0001\u0005\n\t\u001d\"\u0001\u0005#bg\"\u0014w.\u0019:e'\u0016\u0014h/[2f\u0015\tqr$A\u0004tKJ4\u0018nY3\u000b\u0005\u0001\n\u0013!\u00033bg\"\u0014w.\u0019:e\u0015\t\u00113%A\u0004qYV<\u0017N\\:\u000b\u0005\u0011*\u0013!\u0003=me\u0016dW-Y:f\u0015\t1s%A\u0005yK\nL\u0017\r\\1cg*\t\u0001&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\f1\u0003Z1tQ\n|\u0017M\u001d3SKB|7/\u001b;pef\u0004\"a\r\u001c\u000e\u0003QR!!N\u0010\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00028i\tiB)\u001a7fO\u0006$\u0018N\\4ECND'm\\1sIJ+\u0007o\\:ji>\u0014\u00180A\teCND'm\\1sIN+7-\u001e:jif\u0004\"AO\u001e\u000e\u0003uI!\u0001P\u000f\u0003#\u0011\u000b7\u000f\u001b2pCJ$7+Z2ve&$\u00180\u0001\u000eeCND'm\\1sIN+7-\u001e:jif$UmY8sCR|'\u000f\u0005\u0002;\u007f%\u0011\u0001)\b\u0002\u001b\t\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLH)Z2pe\u0006$xN]\u0001\rG\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bQaY1dQ\u0016T!a\u0012%\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!S\u0001\u0004_J<\u0017BA&E\u00051\u0019\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005I+\u0013\u0001\u00033fa2|\u00170\u001b;\n\u0005Q{%a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fQb]2sSB$8+\u001a:wS\u000e,\u0007CA,]\u001b\u0005A&BA-[\u0003\u0019Q\u0017\u0010\u001e5p]*\u00111lI\u0001\u0007g\u000e\u0014\u0018\u000e\u001d;\n\u0005uC&a\u0005&zi\"|gnU2sSB$8+\u001a:wS\u000e,\u0017\u0001C3wK:$()^:\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!aY\u0012\u0002\r\u00154XM\u001c;t\u0013\t)'MA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002SB\u0011!\u000e\\\u0007\u0002W*\u0011adI\u0005\u0003[.\u00141bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"\u0012\"\u001d:tiV4x\u000f_=\u0011\u0005i\u0002\u0001\"B\u0019\f\u0001\u0004\u0011\u0004\"\u0002\u001d\f\u0001\u0004I\u0004\"B\u001f\f\u0001\u0004q\u0004\"B!\f\u0001\u0004\u0011\u0005\"\u0002'\f\u0001\u0004i\u0005\"B+\f\u0001\u00041\u0006\"\u00020\f\u0001\u0004\u0001\u0007\"B4\f\u0001\bI\u0007FA\u0006|!\ra\u0018qA\u0007\u0002{*\u0011ap`\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0001\u0003\u0007\tqAZ1di>\u0014\u0018PC\u0002\u0002\u0006\u0019\u000bQAY3b]NL1!!\u0003~\u0005%\tU\u000f^8xSJ,G-\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0007\u0003\u001f\t\u0019$a\u0012\u0011\r\u0005E\u0011\u0011EA\u0014\u001d\u0011\t\u0019\"!\b\u000f\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007*\u0003\u0019a$o\\8u}%\ta&C\u0002\u0002 5\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"aA*fc*\u0019\u0011qD\u0017\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f \u0003\u0019!w.\\1j]&!\u0011\u0011GA\u0016\u0005%!\u0015m\u001d5c_\u0006\u0014H\rC\u0004\u000261\u0001\r!a\u000e\u0002\u0011A\f'/\u001a8u\u0013\u0012\u0004B!!\u000f\u0002B9!\u00111HA\u001f!\r\t)\"L\u0005\u0004\u0003\u007fi\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005\u0015#AB*ue&twMC\u0002\u0002@5B\u0011\"!\u0013\r!\u0003\u0005\r!a\u000e\u0002\u000bQLG\u000f\\3)\u00071\ti\u0005\u0005\u0003\u0002P\u0005mSBAA)\u0015\rq\u00181\u000b\u0006\u0005\u0003+\n9&A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005es%\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ti&!\u0015\u0003\u000bQKW.\u001a3\u0002!M,\u0017M]2iI\u0011,g-Y;mi\u0012\u0012TCAA2U\u0011\t9$!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003cj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T!A`\u0017\n\t\u0005M\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00054j]\u0012$\u0015m\u001d5c_\u0006\u0014HMQ=JIR!\u0011qEA=\u0011\u001d\tYH\u0004a\u0001\u0003o\t1\u0002Z1tQ\n|\u0017M\u001d3JI\"\u001aa\"!\u0014\u0002\u001f\r\u0014X-\u0019;f\t\u0006\u001c\bNY8be\u0012$B!a\n\u0002\u0004\"1\u0001e\u0004a\u0001\u0003OA3aDA'\u0003=)\b\u000fZ1uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BA\u0014\u0003\u0017Ca\u0001\t\tA\u0002\u0005\u001d\u0002f\u0001\t\u0002N\u0005yA-\u001a7fi\u0016$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0002\u0014\u0006e\u0005c\u0001\u0017\u0002\u0016&\u0019\u0011qS\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003w\n\u0002\u0019AA\u001cQ\r\t\u0012QJ\u0001\u0016O\u0016$H)Y:iE>\f'\u000f\u001a+f[Bd\u0017\r^3t)\u0011\t\t+a.\u0011\r\u0005E\u0011\u0011EAR!\u0011\t)+a-\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000bqA]3gY\u0016\u001cGO\u0003\u0003\u0002.\u0006=\u0016aA1qS*\u0019\u0011\u0011W)\u0002\rAdWoZ5o\u0013\u0011\t),a*\u0003\u0015\u0011+7o\u0019:jaR|'\u000fC\u0004\u0002:J\u0001\r!a/\u0002\u000bM\u001cw\u000e]3\u0011\t\u0005%\u0012QX\u0005\u0005\u0003\u007f\u000bYCA\u0005US2,7kY8qK\"\u001a!#!\u0014\u0002\u001f\u00154\u0018n\u0019;US2,7oQ1dQ\u0016$B!a%\u0002H\"1\u0001e\u0005a\u0001\u0003OA3aEA'\u0003u!WmY8sCR,w+\u001b;i\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sSRLH\u0003BA\b\u0003\u001fDq!!5\u0015\u0001\u0004\ty!\u0001\u0006eCND'm\\1sIN\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003'\u000b9\u000e\u0003\u0004!+\u0001\u0007\u0011qE\u0001\u0012g\u0016$xj\u001e8fe&3W*[:tS:<G\u0003BAJ\u0003;Da\u0001\t\fA\u0002\u0005\u001d\u0012!E2veJ,g\u000e\u001e)sS:\u001c\u0017\u000e]1mgV\u0011\u00111\u001d\t\u0007\u0003K\fY/a<\u000e\u0005\u0005\u001d(bAAu[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0018q\u001d\u0002\t\u0013R,'/\u00192mKB!\u0011\u0011_A~\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018\u0001\u00027b]\u001eT!!!?\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\n\u00190\u0001\u0007dkJ\u0014XM\u001c;S_2,7/\u0006\u0002\u0003\u0002A1!1\u0001B\u0005\u0005\u001bi!A!\u0002\u000b\t\t\u001d\u0011q]\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011YA!\u0002\u0003\r\t+hMZ3s!\rq%qB\u0005\u0004\u0005#y%\u0001\u0002*pY\u0016\f!\u0003\u001d:pm&\u001c\u0018n\u001c8ECND'm\\1sIR!!q\u0003B\u000f!\ra#\u0011D\u0005\u0004\u00057i#aA!os\"1\u0001%\u0007a\u0001\u0003O\ta#\u001a=fGV$X\r\u0015:pm&\u001c\u0018n\u001c8TGJL\u0007\u000f\u001e\u000b\u0005\u0003O\u0011\u0019\u0003\u0003\u0004!5\u0001\u0007\u0011qE\u0001\u0014GJ,\u0017\r^3TGJL\u0007\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0005\u0005S\u0011\t\u0004\u0005\u0003\u0003,\t5R\"\u0001.\n\u0007\t=\"L\u0001\tYYJ\u001c6M]5qi\u000e{g\u000e^3yi\"1\u0001e\u0007a\u0001\u0003OA3\u0001\u0001B\u001b!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e\r\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t}\"\u0011\b\u0002\b'\u0016\u0014h/[2f\u0001")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardCreatedEvent(createdDashboard));
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardUpdatedEvent(updatedDashboard));
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
        this.eventBus().publish((XLReleaseEvent)new DashboardDeletedEvent(dashboard));
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }
}

