/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardCreatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardDeletedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardUpdatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u000f\u001f\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011}\u0003!Q1A\u0005\u0002\u0001D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tQ\u0002\u0011)\u0019!C\u0002S\"Aq\u000e\u0001B\u0001B\u0003%!\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!I\u0011\u0011\u000f\u0001\u0012\u0002\u0013\u0005\u00111\u000f\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!a&\u0001\t\u0003\tI\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAn\u0001\u0011E\u0011Q\u001c\u0005\b\u0003G\u0004A\u0011BAs\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0003\u000e\u0001!IAa\u0004\t\u000f\t\r\u0002\u0001\"\u0003\u0003&!9!q\u0006\u0001\u0005\n\tE\u0002b\u0002B\u001b\u0001\u0011%!q\u0007\u0002\u0011\t\u0006\u001c\bNY8be\u0012\u001cVM\u001d<jG\u0016T!a\b\u0011\u0002\u000fM,'O^5dK*\u0011\u0011EI\u0001\nI\u0006\u001c\bNY8be\u0012T!a\t\u0013\u0002\u000fAdWoZ5og*\u0011QEJ\u0001\nq2\u0014X\r\\3bg\u0016T!a\n\u0015\u0002\u0013a,'-[1mC\n\u001c(\"A\u0015\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g-A\neCND'm\\1sIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00025o5\tQG\u0003\u00027A\u0005Q!/\u001a9pg&$xN]=\n\u0005a*$!\b#fY\u0016<\u0017\r^5oO\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\u0002#\u0011\f7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010\u0005\u0002<y5\ta$\u0003\u0002>=\t\tB)Y:iE>\f'\u000fZ*fGV\u0014\u0018\u000e^=\u00025\u0011\f7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010R3d_J\fGo\u001c:\u0011\u0005m\u0002\u0015BA!\u001f\u0005i!\u0015m\u001d5c_\u0006\u0014HmU3dkJLG/\u001f#fG>\u0014\u0018\r^8s\u00031\u0019\u0017m\u00195f\u001b\u0006t\u0017mZ3s!\t!5*D\u0001F\u0015\t1u)A\u0003dC\u000eDWM\u0003\u0002I\u0013\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u0016\u0013AbQ1dQ\u0016l\u0015M\\1hKJ\f1B]8mKN+'O^5dKB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\tg\u0016\u001cWO]5us*\u00111KJ\u0001\tI\u0016\u0004Hn\\=ji&\u0011Q\u000b\u0015\u0002\f%>dWmU3sm&\u001cW-A\u0007tGJL\u0007\u000f^*feZL7-\u001a\t\u00031vk\u0011!\u0017\u0006\u00035n\u000baA[=uQ>t'B\u0001/%\u0003\u0019\u00198M]5qi&\u0011a,\u0017\u0002\u0014\u0015f$\bn\u001c8TGJL\u0007\u000f^*feZL7-Z\u0001\tKZ,g\u000e\u001e\"vgV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002eI\u00051QM^3oiNL!AZ2\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u0005Y1-[%e'\u0016\u0014h/[2f+\u0005Q\u0007CA6n\u001b\u0005a'BA\u0010%\u0013\tqGNA\u0006DS&#7+\u001a:wS\u000e,\u0017\u0001D2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0005sgR,ho\u001e=zuB\u00111\b\u0001\u0005\u0006e-\u0001\ra\r\u0005\u0006s-\u0001\rA\u000f\u0005\u0006}-\u0001\ra\u0010\u0005\u0006\u0005.\u0001\ra\u0011\u0005\u0006\u001b.\u0001\rA\u0014\u0005\u0006-.\u0001\ra\u0016\u0005\u0006?.\u0001\r!\u0019\u0005\u0006Q.\u0001\u001dA\u001b\u0015\u0003\u0017q\u00042!`A\u0005\u001b\u0005q(bA@\u0002\u0002\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005\r\u0011QA\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\t9aR\u0001\u0006E\u0016\fgn]\u0005\u0004\u0003\u0017q(!C!vi><\u0018N]3e\u0003\u0019)\u00070[:ugR!\u0011\u0011CA\f!\ri\u00131C\u0005\u0004\u0003+q#a\u0002\"p_2,\u0017M\u001c\u0005\b\u00033a\u0001\u0019AA\u000e\u0003-!\u0017m\u001d5c_\u0006\u0014H-\u00133\u0011\t\u0005u\u00111\u0006\b\u0005\u0003?\t9\u0003E\u0002\u0002\"9j!!a\t\u000b\u0007\u0005\u0015\"&\u0001\u0004=e>|GOP\u0005\u0004\u0003Sq\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0005=\"AB*ue&twMC\u0002\u0002*9B3\u0001DA\u001a!\u0011\t)$!\u0011\u000e\u0005\u0005]\"bA@\u0002:)!\u00111HA\u001f\u0003\u001diW\r\u001e:jGNT1!a\u0010)\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\"\u0003o\u0011Q\u0001V5nK\u0012\faa]3be\u000eDGCBA%\u0003O\nY\u0007\u0005\u0004\u0002L\u0005U\u00131\f\b\u0005\u0003\u001b\n\tF\u0004\u0003\u0002\"\u0005=\u0013\"A\u0018\n\u0007\u0005Mc&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\u0004'\u0016\f(bAA*]A!\u0011QLA2\u001b\t\tyFC\u0002\u0002b\u0001\na\u0001Z8nC&t\u0017\u0002BA3\u0003?\u0012\u0011\u0002R1tQ\n|\u0017M\u001d3\t\u000f\u0005%T\u00021\u0001\u0002\u001c\u0005A\u0001/\u0019:f]RLE\rC\u0005\u0002n5\u0001\n\u00111\u0001\u0002\u001c\u0005)A/\u001b;mK\"\u001aQ\"a\r\u0002!M,\u0017M]2iI\u0011,g-Y;mi\u0012\u0012TCAA;U\u0011\tY\"a\u001e,\u0005\u0005e\u0004\u0003BA>\u0003\u0007k!!! \u000b\t\u0005}\u0014\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T!a \u0018\n\t\u0005\u0015\u0015Q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00054j]\u0012$\u0015m\u001d5c_\u0006\u0014HMQ=JIR!\u00111LAF\u0011\u001d\tIb\u0004a\u0001\u00037A3aDA\u001a\u0003=\u0019'/Z1uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BA.\u0003'Ca!\t\tA\u0002\u0005m\u0003f\u0001\t\u00024\u0005yQ\u000f\u001d3bi\u0016$\u0015m\u001d5c_\u0006\u0014H\r\u0006\u0003\u0002\\\u0005m\u0005BB\u0011\u0012\u0001\u0004\tY\u0006K\u0002\u0012\u0003g\tq\u0002Z3mKR,G)Y:iE>\f'\u000f\u001a\u000b\u0005\u0003G\u000bI\u000bE\u0002.\u0003KK1!a*/\u0005\u0011)f.\u001b;\t\u000f\u0005e!\u00031\u0001\u0002\u001c!\u001a!#a\r\u0002+\u001d,G\u000fR1tQ\n|\u0017M\u001d3UK6\u0004H.\u0019;fgR!\u0011\u0011WAd!\u0019\tY%!\u0016\u00024B!\u0011QWAb\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016a\u0002:fM2,7\r\u001e\u0006\u0005\u0003{\u000by,A\u0002ba&T1!!1S\u0003\u0019\u0001H.^4j]&!\u0011QYA\\\u0005)!Um]2sSB$xN\u001d\u0005\b\u0003\u0013\u001c\u0002\u0019AAf\u0003\u0015\u00198m\u001c9f!\u0011\ti&!4\n\t\u0005=\u0017q\f\u0002\n)&dWmU2pa\u0016D3aEA\u001a\u0003=)g/[2u)&dWm]\"bG\",G\u0003BAR\u0003/Da!\t\u000bA\u0002\u0005m\u0003f\u0001\u000b\u00024\u0005iB-Z2pe\u0006$XmV5uQ\u00163g-Z2uSZ,7+Z2ve&$\u0018\u0010\u0006\u0003\u0002J\u0005}\u0007bBAq+\u0001\u0007\u0011\u0011J\u0001\u000bI\u0006\u001c\bNY8be\u0012\u001c\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005\r\u0016q\u001d\u0005\u0007CY\u0001\r!a\u0017\u0002#M,GoT<oKJLe-T5tg&tw\r\u0006\u0003\u0002$\u00065\bBB\u0011\u0018\u0001\u0004\tY&A\tdkJ\u0014XM\u001c;Qe&t7-\u001b9bYN,\"!a=\u0011\r\u0005U\u00181`A\u0000\u001b\t\t9PC\u0002\u0002z:\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti0a>\u0003\u0011%#XM]1cY\u0016\u0004BA!\u0001\u0003\f5\u0011!1\u0001\u0006\u0005\u0005\u000b\u00119!\u0001\u0003mC:<'B\u0001B\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\"1A\u0001\rGV\u0014(/\u001a8u%>dWm]\u000b\u0003\u0005#\u0001bAa\u0005\u0003\u001a\tuQB\u0001B\u000b\u0015\u0011\u00119\"a>\u0002\u000f5,H/\u00192mK&!!1\u0004B\u000b\u0005\u0019\u0011UO\u001a4feB\u0019qJa\b\n\u0007\t\u0005\u0002K\u0001\u0003S_2,\u0017A\u00059s_ZL7/[8o\t\u0006\u001c\bNY8be\u0012$BAa\n\u0003.A\u0019QF!\u000b\n\u0007\t-bFA\u0002B]fDa!\t\u000eA\u0002\u0005m\u0013AF3yK\u000e,H/\u001a)s_ZL7/[8o'\u000e\u0014\u0018\u000e\u001d;\u0015\t\u0005m#1\u0007\u0005\u0007Cm\u0001\r!a\u0017\u0002'\r\u0014X-\u0019;f'\u000e\u0014\u0018\u000e\u001d;D_:$X\r\u001f;\u0015\t\te\"\u0011\t\t\u0005\u0005w\u0011i$D\u0001\\\u0013\r\u0011yd\u0017\u0002\u001112\u00148k\u0019:jaR\u001cuN\u001c;fqRDa!\t\u000fA\u0002\u0005m\u0003f\u0001\u0001\u0003FA!!q\tB'\u001b\t\u0011IEC\u0002\u0003L\u001d\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011yE!\u0013\u0003\u000fM+'O^5dK\u0002")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public boolean exists(String dashboardId) {
        return this.dashboardRepository.exists(dashboardId);
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardCreatedEvent(createdDashboard));
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardUpdatedEvent(updatedDashboard));
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
        this.eventBus().publish((XLReleaseEvent)new DashboardDeletedEvent(dashboard));
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }
}

