/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.api.v1.ApplicationApi;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.api.v1.form.ApplicationForm;
import com.xebialabs.xlrelease.api.v1.views.ApplicationView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ApplicationApiImpl
implements ApplicationApi {
    private ApplicationService applicationService;

    @Autowired
    public ApplicationApiImpl(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Timed
    public ApplicationView createApplication(ApplicationForm applicationForm) {
        return ApplicationView.fromApplication((Application)this.applicationService.createApplication(applicationForm.toApplication()));
    }

    @Timed
    public ApplicationView getApplication(String applicationId) {
        return ApplicationView.fromApplication((Application)this.applicationService.findApplicationById(applicationId));
    }

    @Timed
    public ApplicationView updateApplication(String applicationId, ApplicationForm applicationForm) {
        Application application = applicationForm.toApplication();
        application.setId(applicationId);
        return ApplicationView.fromApplication((Application)this.applicationService.updateApplication(application));
    }

    @Timed
    public List<ApplicationView> searchApplications(ApplicationFilters applicationFilters) {
        return this.applicationService.searchApplications(applicationFilters).stream().map(ApplicationView::fromApplication).collect(Collectors.toList());
    }

    @Timed
    public void deleteApplication(String applicationId) {
        this.applicationService.deleteApplication(applicationId);
    }

    @Timed
    public Application create(Application application) {
        return this.applicationService.createApplication(application);
    }

    @Timed
    public Application getById(String applicationId) {
        return this.applicationService.findApplicationById(applicationId);
    }

    @Timed
    public Application update(Application application) {
        return this.applicationService.updateApplication(application);
    }

    @Timed
    public List<Application> search(ApplicationFilters filters) {
        return this.applicationService.searchApplications(filters);
    }
}

