import React from 'react';
import { EnvironmentEditPageComponent } from './environment-edit-page-component';
import { preparePortalContainer, mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ReactWrapper, shallow } from 'enzyme';
import { EnvironmentFormComponent } from './environment-form-component';
import { environmentState } from '../__mocks__/environment-list.mocks';
import { EnvironmentEditPage } from './environment-edit-page';

describe('Environment edit page', () => {
    beforeEach(() => {
        preparePortalContainer();
    });

    const dispatch = jest.fn();
    const state = environmentState;

    it('should load page', () => {
        const page = shallow(<EnvironmentEditPage environmentId={'id'} folderId={''} />);
        expect(page).toExist();
    });

    it('should render edit page component', () => {
        const environmentId = 'someEnvironmentId';
        const folderId = 'Folder42';
        const environmentPage: ReactWrapper = mountWithStoreAndTheme(<EnvironmentEditPageComponent {...{ environmentId, folderId }} />, dispatch, state);
        const component = environmentPage.find(EnvironmentFormComponent);
        expect(component).toExist();
    });
});
