import { Environment, Label, Stage } from '../../../application-list.types';
import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';

export const stage: Stage = {
    id: '1',
    title: 'someStage',
};

const stage2: Stage = {
    id: '2',
    title: 'someStage2',
};

const stage3: Stage = {
    id: '3',
    title: 'someStage3',
};

export const stages: Array<Stage> = [stage, stage2, stage3];

export const label: Label = {
    color: 'blue',
    id: '2',
    title: 'label1',
};

const label2: Label = {
    color: 'green',
    id: '5',
    title: 'label2',
};

export const newLabel: Label = {
    color: 'white',
    id: '',
    title: 'new label',
};

export const labels: Array<Label> = [label, label2];
export const env: Environment = {
    description: 'testEnv',
    folderId: '',
    id: '',
    labels: [label],
    stage,
    title: 'test environment',
};

export const env2: Environment = {
    description: 'testEnv',
    folderId: '',
    id: '',
    labels: [label],
    stage,
    title: 'test environment 2',
};

export const env3: Environment = {
    description: 'testEnv',
    folderId: '',
    id: '',
    labels: [label],
    stage,
    title: 'test environment 3',
};

export const envWithId: Environment = {
    description: 'testEnv',
    folderId: '',
    id: '123',
    labels: [label],
    stage,
    title: 'test environment 3',
};

export const envList: Array<Environment> = [env, env2, env3];

export const envList2: Array<Environment> = [...envList, envWithId];
export const envInFolder: Environment = {
    description: 'testEnv42',
    folderId: 'Folder42',
    id: '',
    labels: [label],
    stage,
    title: 'test environment - Folder42',
};

export const environmentState: RootState = {
    environmentForm: {
        environmentModel: {
            description: '',
            folderId: '',
            id: '',
            labels: [],
            stage: {},
            title: '',
        },
        saveEnabled: true,
    },
    environmentList: {
        stages: [],
        environments: [],
    },
    labelsState: {
        labelList: [],
    },
    stageState: {
        stageList: [],
    },
};

export const model: Environment = {
    description: 'my description',
    folderId: '',
    id: 'envid',
    labels: [],
    stage: { id: 'EnvironmentStage1', title: 'test' },
    title: 'my name',
};

export const stageList: Array<Stage> = [
    { id: 'EnvironmentStage1', title: 'test' },
    { id: 'EnvironmentStage2', title: 'prod' },
];

export const envStateWithModel: RootState = {
    ...environmentState,
    environmentForm: {
        environmentModel: model,
    },
    environmentList: {
        stages: stageList,
        environments: [
            ...envList,
            {
                description: 'my description',
                folderId: '',
                id: 'envid',
                labels: [],
                stage: { id: 'EnvironmentStage1', title: 'test' },
                title: 'my name',
            },
            {
                description: 'my description',
                folderId: '',
                id: '',
                labels: [],
                stage: { id: 'EnvironmentStage1', title: 'test' },
                title: 'used',
            },
            {
                description: 'my description',
                folderId: '',
                id: '',
                labels: [],
                stage: { id: 'EnvironmentStage1', title: 'test' },
                title: 'usedstill',
            },
        ],
    },
    stageState: { stageList },
};

const labelList = [
    {
        id: 'EnvironmentLabel1',
        title: 'Label1',
        color: '#aabbcc',
    },
    {
        id: 'EnvironmentLabel2',
        title: 'Label1',
        color: '#aabbcc',
    },
];

export const stateForForm = {
    labelsState: labelList,
};

const label3: Label = {
    color: 'blue',
    id: '3',
    title: 'label3',
};

const label4: Label = {
    color: 'blue',
    id: '4',
    title: 'label4',
};

export const label5: Label = {
    color: 'blue',
    id: '5',
    title: 'label5',
};

export const label6: Label = {
    color: 'blue',
    id: '6',
    title: 'label6',
};

export const bigLabelsList = [...labelList, newLabel, ...labels, label3, label4, label5, label6];
