import { initialState, stageState } from './stage.reducer';
import { stage } from '../__mocks__/environment-list.mocks';

const { setStages, searchStages, deleteStage, saveStage } = stageState.actions;

describe('Stages reducer', () => {
    it('should have initial state', () => {
        expect(stageState.name).toBe('stageState');
        expect(stageState.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    it('should set stages', () => {
        const state = stageState.reducer(initialState, setStages([stage]));
        expect(state.stageList).toStrictEqual([stage]);
    });

    it('search should not set stages', () => {
        const state = stageState.reducer(initialState, searchStages(''));
        expect(state).toStrictEqual(initialState);
    });

    it('delete should not update state', () => {
        const state = stageState.reducer(initialState, deleteStage(stage));
        expect(state).toStrictEqual(initialState);
    });

    it('save should not set stages', () => {
        const state = stageState.reducer(initialState, saveStage(stage));
        expect(state).toStrictEqual(initialState);
    });
});
