/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import com.xebialabs.xlrelease.environments.service.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00015\u0011Q$\u00128wSJ|g.\\3oiJ+7/\u001a:wCRLwN\\*feZL7-\u001a\u0006\u0003\u0007\u0011\tqa]3sm&\u001cWM\u0003\u0002\u0006\r\u0005aQM\u001c<je>tW.\u001a8ug*\u0011q\u0001C\u0001\nq2\u0014X\r\\3bg\u0016T!!\u0003\u0006\u0002\u0013a,'-[1mC\n\u001c(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tQa\u001d7gi)T\u0011!G\u0001\tOJL'P\u001f7fI&\u00111D\u0006\u0002\b\u0019><w-\u001b8h\u0011!i\u0002A!A!\u0002\u0013q\u0012\u0001I3om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002$A\t\u0001SI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|gNU3q_NLGo\u001c:z\u0011!)\u0003A!A!\u0002\u00131\u0013AE3om&\u0014xN\\7f]R\u001cVM\u001d<jG\u0016\u0004\"a\n\u0015\u000e\u0003\tI!!\u000b\u0002\u0003%\u0015sg/\u001b:p]6,g\u000e^*feZL7-\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005\u0011\u0012\r\u001d9mS\u000e\fG/[8o'\u0016\u0014h/[2f!\t9S&\u0003\u0002/\u0005\t\u0011\u0012\t\u001d9mS\u000e\fG/[8o'\u0016\u0014h/[2f\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q!!g\r\u001b6!\t9\u0003\u0001C\u0003\u001e_\u0001\u0007a\u0004C\u0003&_\u0001\u0007a\u0005C\u0003,_\u0001\u0007A\u0006\u000b\u00020oA\u0011\u0001hQ\u0007\u0002s)\u0011!hO\u0001\u000bC:tw\u000e^1uS>t'B\u0001\u001f>\u0003\u001d1\u0017m\u0019;pefT!AP \u0002\u000b\t,\u0017M\\:\u000b\u0005\u0001\u000b\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\t\u000b1a\u001c:h\u0013\t!\u0015HA\u0005BkR|w/\u001b:fI\")a\t\u0001C\u0001\u000f\u0006\u00112/Z1sG\"\u0014Vm]3sm\u0006$\u0018n\u001c8t)\tAU\f\u0005\u0003J\u001dB;V\"\u0001&\u000b\u0005-c\u0015\u0001B;uS2T\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n\u0019Q*\u00199\u0011\u0005E+V\"\u0001*\u000b\u0005\u0015\u0019&B\u0001+\u0007\u0003\u0019!w.\\1j]&\u0011aK\u0015\u0002\f\u000b:4\u0018N]8o[\u0016tG\u000fE\u0002J1jK!!\u0017&\u0003\t1K7\u000f\u001e\t\u0003#nK!\u0001\u0018*\u0003-\u0015sg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:DQAX#A\u0002}\u000bqAZ5mi\u0016\u00148\u000f\u0005\u0002aO6\t\u0011M\u0003\u0002cG\u00061a-\u001b7uKJT!\u0001Z3\u0002\u0005Y\f$B\u00014\u0007\u0003\r\t\u0007/[\u0005\u0003Q\u0006\u0014!CU3tKJ4\u0018\r^5p]\u001aKG\u000e^3sg\"\u0012QI\u001b\t\u0003WFl\u0011\u0001\u001c\u0006\u0003u5T!A\\8\u0002\u000f5,GO]5dg*\u0011\u0001OC\u0001\tG>$\u0017\r[1mK&\u0011!\u000f\u001c\u0002\u0006)&lW\r\u001a\u0005\u0006i\u0002!\t!^\u0001\u0014M&tGMU3tKJ4\u0018\r^5p]\nK\u0018\n\u001a\u000b\u00035ZDQa^:A\u0002a\f\u0001$\u001a8wSJ|g.\\3oiJ+7/\u001a:wCRLwN\\%e!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a\u001f\t\u000e\u0003qT!! \u0007\u0002\rq\u0012xn\u001c;?\u0013\ty\b#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fBA#a\u001d6\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005qr-\u001a;SKN,'O^1uS>t7OQ=F]ZL'o\u001c8nK:$\u0018\n\u001a\u000b\u0004/\u0006=\u0001bBA\t\u0003\u0013\u0001\r\u0001_\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133)\u0007\u0005%!\u000eC\u0004\u0002\u0018\u0001!\t!!\u0007\u0002#\r\u0014X-\u0019;f%\u0016\u001cXM\u001d<bi&|g\u000eF\u0002[\u00037Aq!!\b\u0002\u0016\u0001\u0007!,\u0001\ff]ZL'o\u001c8nK:$(+Z:feZ\fG/[8oQ\r\t)B\u001b\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003E)\b\u000fZ1uKJ+7/\u001a:wCRLwN\u001c\u000b\u00045\u0006\u001d\u0002bBA\u000f\u0003C\u0001\rA\u0017\u0015\u0004\u0003CQ\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0012I\u0016dW\r^3SKN,'O^1uS>tG\u0003BA\u0019\u0003o\u00012aDA\u001a\u0013\r\t)\u0004\u0005\u0002\u0005+:LG\u000f\u0003\u0004x\u0003W\u0001\r\u0001\u001f\u0015\u0004\u0003WQ\u0007bBA\u001f\u0001\u0011\u0005\u0011qH\u0001\u0012KbL7\u000f^:SKN,'O^1uS>tGCBA!\u0003\u000f\nI\u0005E\u0002\u0010\u0003\u0007J1!!\u0012\u0011\u0005\u001d\u0011un\u001c7fC:Dq!!\u0005\u0002<\u0001\u0007\u0001\u0010C\u0004\u0002L\u0005m\u0002\u0019\u0001=\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%eQ\r\tYD\u001b\u0005\b\u0003#\u0002A\u0011BA*\u0003!1\u0018\r\\5eCR,G\u0003BA\u0019\u0003+Bq!!\b\u0002P\u0001\u0007!\fC\u0004\u0002Z\u0001!I!a\u0017\u0002\u001bY\fG.\u001b3bi\u0016$\u0015\r^3t)\u0011\t\t$!\u0018\t\u000f\u0005u\u0011q\u000ba\u00015\"9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0014\u0001\u0004<bY&$\u0017\r^3O_R,G\u0003BA\u0019\u0003KBq!!\b\u0002`\u0001\u0007!\fC\u0004\u0002j\u0001!I!a\u001b\u0002)Y\fG.\u001b3bi\u0016\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t)\u0011\t\t$!\u001c\t\u000f\u0005u\u0011q\ra\u00015\"\u001a\u0001!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e@\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003w\n)HA\u0004TKJ4\u0018nY3")
public class EnvironmentReservationService
implements Logging {
    private final EnvironmentReservationRepository environmentReservationRepository;
    private final ApplicationService applicationService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentReservationService environmentReservationService = this;
        synchronized (environmentReservationService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public java.util.Map<Environment, List<EnvironmentReservation>> searchReservations(ReservationFilters filters) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.environmentReservationRepository.search(filters, package$.MODULE$.defaultPage()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava())).asJava();
    }

    @Timed
    public EnvironmentReservation findReservationById(String environmentReservationId) {
        return this.environmentReservationRepository.findById(environmentReservationId);
    }

    @Timed
    public List<EnvironmentReservation> getReservationsByEnvironmentId(String environmentId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentReservationRepository.getAllForEnvironmentId(environmentId)).asJava();
    }

    @Timed
    public EnvironmentReservation createReservation(EnvironmentReservation environmentReservation) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating a new environment reservation"})).s((Seq)Nil$.MODULE$));
        this.validate(environmentReservation);
        return this.environmentReservationRepository.create(environmentReservation);
    }

    @Timed
    public EnvironmentReservation updateReservation(EnvironmentReservation environmentReservation) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating environment reservation [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentReservation})));
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentReservation);
        return this.environmentReservationRepository.update(environmentReservation);
    }

    @Timed
    public void deleteReservation(String environmentReservationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting environment reservation [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentReservationId})));
        this.environmentReservationRepository.delete(environmentReservationId);
    }

    @Timed
    public boolean existsReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking reservation for environmentId [", "] and applicationId [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentId, applicationId})));
        return this.environmentReservationRepository.existsByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date());
    }

    private void validate(EnvironmentReservation environmentReservation) {
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environmentReservation.getEnvironment()).exists((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationService.$anonfun$validate$1(env))), (String)"Environment ID is required", (Object[])new Object[0]);
        this.validateDates(environmentReservation);
        this.validateNote(environmentReservation);
        this.validateApplications(environmentReservation);
    }

    private void validateDates(EnvironmentReservation environmentReservation) {
        Date startDate = environmentReservation.getStartDate();
        Date endDate = environmentReservation.getEndDate();
        Checks.checkArgument((startDate != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((endDate != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)startDate.before(endDate), (String)"Start date must be before the end date", (Object[])new Object[0]);
    }

    private void validateNote(EnvironmentReservation environmentReservation) {
        block0: {
            if (environmentReservation.getNote() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getNote()), (String)"Note cannot be blank", (Object[])new Object[0]);
        }
    }

    private void validateApplications(EnvironmentReservation environmentReservation) {
        if (CollectionUtils.isNotEmpty(environmentReservation.getApplications())) {
            Set allowedAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.applicationService.getApplicationsDeployableOnEnvironment(environmentReservation.getEnvironment().getId())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set givenAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environmentReservation.getApplications()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set diff = (Set)givenAppIds.diff((GenSet)allowedAppIds);
            if (diff.nonEmpty()) {
                Tuple2 tuple2 = diff.splitAt(10);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Set first10 = (Set)tuple2._1();
                Set rest = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)first10, (Object)rest);
                Tuple2 tuple23 = tuple22;
                Set first102 = (Set)tuple23._1();
                Set rest2 = (Set)tuple23._2();
                throw new Checks.IncorrectArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |The following applications are not deployable on environment [", "]:\n             |[", "] ", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentReservation.getEnvironment().getId(), first102.mkString(", "), rest2.nonEmpty() ? ", and more" : BoxedUnit.UNIT})))).stripMargin(), new Object[0]);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Environment env) {
        return StringUtils.hasText((String)env.getId());
    }

    @Autowired
    public EnvironmentReservationService(EnvironmentReservationRepository environmentReservationRepository, EnvironmentService environmentService, ApplicationService applicationService) {
        this.environmentReservationRepository = environmentReservationRepository;
        this.applicationService = applicationService;
        Logging.$init$((Logging)this);
    }
}

