/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentLabelPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentStagePersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENV_TO_LABEL$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t%e\u0001B\u0001\u0003\u0001E\u0011a#\u00128wSJ|g.\\3oiB+'o]5ti\u0016t7-\u001a\u0006\u0003\u0007\u0011\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\tA\"\u001a8wSJ|g.\\3oiNT!a\u0003\u0007\u0002\u0013ad'/\u001a7fCN,'BA\u0007\u000f\u0003%AXMY5bY\u0006\u00147OC\u0001\u0010\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eiR\"\u0001\u000e\u000b\u0005\rY\"BA\u0003\u001d\u0015\t9!\"\u0003\u0002\u001f5\t\u0011\u0002+\u001a:tSN$XM\\2f'V\u0004\bo\u001c:u\u0011!\u0001\u0003A!b\u0001\n\u0007\t\u0013\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u0012\u0011\u0005\rbS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2pe\u0016T!a\n\u0015\u0002\t)$'m\u0019\u0006\u0003S)\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002W\u0005\u0019qN]4\n\u00055\"#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!\t\u0004A!b\u0001\n\u0007\u0011\u0014a\u00023jC2,7\r^\u000b\u0002gA\u0011Ag\u0012\b\u0003k\u0011s!A\u000e\"\u000f\u0005]\u0002eB\u0001\u001d@\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=!\u00051AH]8pizJ\u0011aD\u0005\u0003\u001b9I!a\u0003\u0007\n\u0005\u0005S\u0011A\u00013c\u0013\t)1I\u0003\u0002B\u0015%\u0011QIR\u0001\u000b'Fd')^5mI\u0016\u0014(BA\u0003D\u0013\tA\u0015JA\u0004ES\u0006dWm\u0019;\u000b\u0005\u00153\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0011\u0011L\u0017\r\\3di\u0002B\u0001\"\u0014\u0001\u0003\u0006\u0004%\u0019AT\u0001\fG&LEmU3sm&\u001cW-F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011&\"A\u0004tKJ4\u0018nY3\n\u0005Q\u000b&aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016D\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IaT\u0001\rG&LEmU3sm&\u001cW\r\t\u0005\t1\u0002\u0011)\u0019!C\u00013\u0006!2/Z2ve\u0006\u0014G.\u001a)feNL7\u000f^3oG\u0016,\u0012A\u0017\t\u00033mK!\u0001\u0018\u000e\u0003)M+7-\u001e:bE2,\u0007+\u001a:tSN$XM\\2f\u0011!q\u0006A!A!\u0002\u0013Q\u0016!F:fGV\u0014\u0018M\u00197f!\u0016\u00148/[:uK:\u001cW\r\t\u0005\tA\u0002\u0011)\u0019!C\u0001C\u0006YRM\u001c<je>tW.\u001a8u'R\fw-\u001a)feNL7\u000f^3oG\u0016,\u0012A\u0019\t\u0003G\u0012l\u0011AA\u0005\u0003K\n\u00111$\u00128wSJ|g.\\3oiN#\u0018mZ3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00022\u00029\u0015tg/\u001b:p]6,g\u000e^*uC\u001e,\u0007+\u001a:tSN$XM\\2fA!A\u0011\u000e\u0001BC\u0002\u0013\u0005!.A\u000ef]ZL'o\u001c8nK:$H*\u00192fYB+'o]5ti\u0016t7-Z\u000b\u0002WB\u00111\r\\\u0005\u0003[\n\u00111$\u00128wSJ|g.\\3oi2\u000b'-\u001a7QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011B6\u00029\u0015tg/\u001b:p]6,g\u000e\u001e'bE\u0016d\u0007+\u001a:tSN$XM\\2fA!)\u0011\u000f\u0001C\u0001e\u00061A(\u001b8jiz\"\u0012a\u001d\u000b\riV\fI!!\u0005\u0002\u0014\u0005U\u0011q\u0003\t\u0003G\u0002AQ\u0001\t9A\u0004\tBc!^<\u0002\u0004\u0005\u0015\u0001C\u0001=\u0000\u001b\u0005I(B\u0001>|\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003yv\fqAZ1di>\u0014\u0018P\u0003\u0002\u007fQ\u0005)!-Z1og&\u0019\u0011\u0011A=\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017EAA\u0004\u0003eAHN\u001d*fa>\u001c\u0018\u000e^8ss*#'m\u0019+f[Bd\u0017\r^3\t\u000bE\u0002\b9A\u001a)\u000f\u0005%q/a\u0001\u0002\u000e\u0005\u0012\u0011qB\u0001\u0018q2\u0014(+\u001a9pg&$xN]=Tc2$\u0015.\u00197fGRDQ!\u00149A\u0004=CQ\u0001\u00179A\u0002iCQ\u0001\u00199A\u0002\tDQ!\u001b9A\u0002-D3\u0001]A\u000e!\rA\u0018QD\u0005\u0004\u0003?I(!C!vi><\u0018N]3e\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)#\u0001\rT)6#v,\u0013(T\u000bJ#v,\u0012(W\u0013J{e*T#O)N+\"!a\n\u0011\t\u0005%\u0012\u0011\u0007\b\u0005\u0003W\ti\u0003\u0005\u0002;)%\u0019\u0011q\u0006\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019$!\u000e\u0003\rM#(/\u001b8h\u0015\r\ty\u0003\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002(\u0005I2\u000bV'U?&s5+\u0012*U?\u0016se+\u0013*P\u001d6+e\nV*!\u0011%\ti\u0004\u0001b\u0001\n\u0013\t)#A\u0010T)6#v,\u0012-J'R\u001bvLQ-`)&#F*R0J\u000f:{%+R\"B'\u0016C\u0001\"!\u0011\u0001A\u0003%\u0011qE\u0001!'RkEkX#Y\u0013N#6k\u0018\"Z?RKE\u000bT#`\u0013\u001esuJU#D\u0003N+\u0005\u0005C\u0004\u0002F\u0001!\t!a\u0012\u0002\r%t7/\u001a:u)\u0011\tI%a\u0019\u0011\t\u0005-\u0013Q\f\b\u0005\u0003\u001b\nIF\u0004\u0003\u0002P\u0005]c\u0002BA)\u0003+r1aNA*\u0013\t9!\"\u0003\u0002\u00069%\u00111aG\u0005\u0004\u00037R\u0012\u0001B\"j\u0013\u0012LA!a\u0018\u0002b\t!1)[%e\u0015\r\tYF\u0007\u0005\t\u0003K\n\u0019\u00051\u0001\u0002h\u0005YQM\u001c<je>tW.\u001a8u!\u0011\tI'!\u001d\u000e\u0005\u0005-$bA\u0005\u0002n)\u0019\u0011q\u000e\u0006\u0002\r\u0011|W.Y5o\u0013\u0011\t\u0019(a\u001b\u0003\u0017\u0015sg/\u001b:p]6,g\u000e\u001e\u0005\n\u0003o\u0002!\u0019!C\u0005\u0003K\t\u0001d\u0015+N)~+\u0006\u000bR!U\u000b~+eJV%S\u001f:kUI\u0014+T\u0011!\tY\b\u0001Q\u0001\n\u0005\u001d\u0012!G*U\u001bR{V\u000b\u0015#B)\u0016{VI\u0014,J%>sU*\u0012(U'\u0002B\u0011\"a \u0001\u0005\u0004%I!!\n\u0002EM#V\nV0F1&\u001bFkU0B\u001d>#\u0006*\u0012*`\u000b:3vlV%U\u0011~#\u0016\n\u0016'F\u0011!\t\u0019\t\u0001Q\u0001\n\u0005\u001d\u0012aI*U\u001bR{V\tW%T)N{\u0016IT(U\u0011\u0016\u0013v,\u0012(W?^KE\u000bS0U\u0013RcU\t\t\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003\u0019)\b\u000fZ1uKR!\u00111RAI!\r\u0019\u0012QR\u0005\u0004\u0003\u001f#\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003K\n)\t1\u0001\u0002h!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015A\u00044j]\u0012LEm\u001d\"z#V,'/\u001f\u000b\u0005\u00033\u000bY\u000b\u0005\u0004\u0002\u001c\u0006\u0015\u0016\u0011\n\b\u0005\u0003;\u000b\tKD\u0002;\u0003?K\u0011!F\u0005\u0004\u0003G#\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003O\u000bIKA\u0002TKFT1!a)\u0015\u0011!\ti+a%A\u0002\u0005=\u0016!E:rY^KG\u000f\u001b)be\u0006lW\r^3sgB!\u0011\u0011WA[\u001d\r)\u00141W\u0005\u0004\u0003G3\u0015\u0002BA\\\u0003s\u0013\u0011cU9m/&$\b\u000eU1sC6,G/\u001a:t\u0015\r\t\u0019K\u0012\u0005\b\u0003{\u0003A\u0011AA`\u0003!1\u0017N\u001c3Cs&#G\u0003BAa\u0003\u000f\u0004RaEAb\u0003OJ1!!2\u0015\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011ZA^\u0001\u0004\tI%A\u0007f]ZL'o\u001c8nK:$\u0018\n\u001a\u0005\b\u0003\u001b\u0004A\u0011AAh\u0003-1\u0017N\u001c3VS\u0012\u0014\u00150\u00133\u0015\t\u0005E\u0017q\u001c\t\u0006'\u0005\r\u00171\u001b\t\u0005\u0003+\fIN\u0004\u0003\u0002N\u0005]\u0017bAAR5%!\u00111\\Ao\u0005\u0015\u0019\u0015.V5e\u0015\r\t\u0019K\u0007\u0005\t\u0003\u0013\fY\r1\u0001\u0002J!9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\u0018AB:fCJ\u001c\u0007\u000e\u0006\u0003\u0002h\u0006%\bCBAN\u0003K\u000b9\u0007\u0003\u0005\u0002.\u0006\u0005\b\u0019AAX\u0011%\ti\u000f\u0001b\u0001\n\u0013\t)#\u0001\u0010T)6#v\fR#M\u000bR+u,\u0012(W\u0013J{e*T#O)N{&)W0J\t\"A\u0011\u0011\u001f\u0001!\u0002\u0013\t9#A\u0010T)6#v\fR#M\u000bR+u,\u0012(W\u0013J{e*T#O)N{&)W0J\t\u0002Bq!!>\u0001\t\u0003\t90\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003s\u0014)\u0001\u0005\u0004\u0002|\n\u0005\u00111R\u0007\u0003\u0003{T1!a@\u0015\u0003\u0011)H/\u001b7\n\t\t\r\u0011Q \u0002\u0004)JL\b\u0002CAe\u0003g\u0004\r!!\u0013\t\u000f\t%\u0001\u0001\"\u0003\u0003\f\u0005aq-\u001a;MC\n,G.V5egR!!Q\u0002B\n!!\tICa\u0004\u0002J\u0005M\u0017\u0002\u0002B\t\u0003k\u00111!T1q\u0011!\t)Ga\u0002A\u0002\u0005\u001d\u0004b\u0002B\f\u0001\u0011%!\u0011D\u0001\u001bS:\u001cXM\u001d;F]Z$v\u000eT1cK2\u0014VMZ3sK:\u001cWm\u001d\u000b\u0007\u00057\u0011\u0019Ca\n\u0011\r\u0005m\u0015Q\u0015B\u000f!\r\u0019\"qD\u0005\u0004\u0005C!\"aA%oi\"A!Q\u0005B\u000b\u0001\u0004\t\u0019.\u0001\bf]ZL'o\u001c8nK:$X+\u001b3\t\u0011\t%\"Q\u0003a\u0001\u0005W\t\u0011\u0002\\1cK2,\u0016\u000eZ:\u0011\r\u0005%\"QFAj\u0013\u0011\u0011y#!\u000e\u0003\u0007M+G\u000fC\u0004\u00034\u0001!IA!\u000e\u00025U\u0004H-\u0019;f\u000b:4Hk\u001c'bE\u0016d'+\u001a4fe\u0016t7-Z:\u0015\r\tm!q\u0007B\u001d\u0011!\t)G!\rA\u0002\u0005\u001d\u0004\u0002\u0003B\u0013\u0005c\u0001\r!a5\t\u000f\tu\u0002\u0001\"\u0001\u0003@\u0005aq-\u001a;VS\u0012\u001c()_%egR!!Q\u0002B!\u0011!\u0011\u0019Ea\u000fA\u0002\t\u0015\u0013AD3om&\u0014xN\\7f]RLEm\u001d\t\u0007\u00037\u00139%!\u0013\n\t\t%\u0013\u0011\u0016\u0002\t\u0013R,'/\u00192mK\"9!Q\n\u0001\u0005\n\t=\u0013\u0001G:b]&$\u0018N_3F]ZL'o\u001c8nK:$\u0018J\u001c9viR!!\u0011\u000bB,!\r\u0019\"1K\u0005\u0004\u0005+\"\"\u0001B+oSRD\u0001\"!\u001a\u0003L\u0001\u0007\u0011q\r\u0015\u0004\u0001\tm\u0003\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\u0007\t\u0005d)A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002B3\u0005?\u0012q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0015\u0004\u0001\t%\u0004\u0003\u0002B6\u0005cj!A!\u001c\u000b\u0007\t=\u0004&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u001d\u0003n\tQ!+\u001a9pg&$xN]=)\u000f\u0001\u00119(a\u0001\u0003\u0006B!!\u0011\u0010BA\u001b\t\u0011YHC\u0002{\u0005{R1Aa )\u0003\u001d\u0019wN\u001c;fqRLAAa!\u0003|\t9\u0001K]8gS2,GF\u0001BDC\u0005)\u0001")
public class EnvironmentPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final SecurablePersistence securablePersistence;
    private final EnvironmentStagePersistence environmentStagePersistence;
    private final EnvironmentLabelPersistence environmentLabelPersistence;
    private final String STMT_INSERT_ENVIRONMENTS;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE;
    private final String STMT_UPDATE_ENVIRONMENTS;
    private final String STMT_EXISTS_ANOTHER_ENV_WITH_TITLE;
    private final String STMT_DELETE_ENVIRONMENTS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, Map<String, Object> params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        EnvironmentPersistence environmentPersistence = this;
        synchronized (environmentPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    public EnvironmentStagePersistence environmentStagePersistence() {
        return this.environmentStagePersistence;
    }

    public EnvironmentLabelPersistence environmentLabelPersistence() {
        return this.environmentLabelPersistence;
    }

    private String STMT_INSERT_ENVIRONMENTS() {
        return this.STMT_INSERT_ENVIRONMENTS;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE;
    }

    public String insert(Environment environment) {
        this.sanitizeEnvironmentInput(environment);
        Integer stageUid = (Integer)this.environmentStagePersistence().findUidById(environment.getStage().getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment stage [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment.getStage().getId()})), new Object[0]);
        });
        boolean exists = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE_IGNORECASE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle())})), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentPersistence.$anonfun$insert$2(x$1))).head());
        if (exists) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment with title '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment.getTitle()})));
        }
        Map<String, Integer> labelIdsToUids = this.getLabelUids(environment);
        Integer ciUid = this.securablePersistence().insert();
        String envId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Environment.class), this.ciIdService());
        String displayedEnvId = package$.MODULE$.toDisplayId(envId);
        try {
            this.sqlExec(this.STMT_INSERT_ENVIRONMENTS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()), (Object)envId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()), (Object)environment.getDescription()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()), (Object)stageUid)})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment with ID '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{displayedEnvId})), ex);
        }
        this.insertEnvToLabelReferences(ciUid, (Set<Integer>)labelIdsToUids.valuesIterator().toSet());
        return displayedEnvId;
    }

    private String STMT_UPDATE_ENVIRONMENTS() {
        return this.STMT_UPDATE_ENVIRONMENTS;
    }

    private String STMT_EXISTS_ANOTHER_ENV_WITH_TITLE() {
        return this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE;
    }

    public boolean update(Environment environment) {
        Integer environmentUid = (Integer)this.findUidById(environment.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment.getId()})), new Object[0]);
        });
        Integer stageUid = (Integer)this.environmentStagePersistence().findUidById(environment.getStage().getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment stage [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment.getStage().getId()})), new Object[0]);
        });
        this.sanitizeEnvironmentInput(environment);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)environmentUid)})), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentPersistence.$anonfun$update$3(x$3))).head());
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment with title '", "' already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment.getTitle()})));
        }
        this.updateEnvToLabelReferences(environment, environmentUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_ENVIRONMENTS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION()), (Object)environment.getDescription()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)environment.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()), (Object)stageUid)})), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 == 1));
    }

    public Seq<String> findIdsByQuery(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), String.class)).asScala();
    }

    public Option<Environment> findById(String environmentId) {
        Tuple2<String, Seq<Object>> tuple2 = EnvironmentSqlBuilder$.MODULE$.apply(EnvironmentSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withEnvironmentId(package$.MODULE$.toPersistedId(environmentId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentResultSetExtractor(Mappers$.MODULE$.environmentResultSetExtractor$default$1(), Mappers$.MODULE$.environmentResultSetExtractor$default$2()));
    }

    public Option<Integer> findUidById(String environmentId) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|SELECT ", "\n          |FROM ", "\n          |WHERE ", " = :environmentId"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()})))).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId))})), (Function1 & Serializable & scala.Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()))).headOption();
    }

    public Seq<Environment> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.environmentSearchResultSetExtractor());
    }

    private String STMT_DELETE_ENVIRONMENTS_BY_ID() {
        return this.STMT_DELETE_ENVIRONMENTS_BY_ID;
    }

    public Try<Object> delete(String environmentId) {
        return (Try)this.sqlExec(this.STMT_DELETE_ENVIRONMENTS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> getLabelUids(Environment environment) {
        Map map;
        if (CollectionUtils.isEmpty(environment.getLabels())) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            void var3_3;
            Map<String, Integer> labelIdsToUids;
            Set labelIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environment.getLabels()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set labelDiff = (Set)labelIds.diff((GenSet)(labelIdsToUids = this.environmentLabelPersistence().getUidsByIds((Iterable<String>)labelIds)).keySet());
            if (labelDiff.nonEmpty()) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Environment labels [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{labelDiff.mkString(", ")})), new Object[0]);
            }
            map = var3_3;
        }
        return map;
    }

    private Seq<Object> insertEnvToLabelReferences(Integer environmentUid, Set<Integer> labelUids) {
        String insertEnvToLabelStmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " (\n         |", ",\n         |", "\n         |)\n         |VALUES (\n         |:", ",\n         |:", "\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE(), EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID(), EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID(), EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID(), EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID()})))).stripMargin();
        return this.sqlBatch(insertEnvToLabelStmt, (Set<Map<String, Object>>)((Set)labelUids.map((Function1 & Serializable & scala.Serializable)labelUid -> Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID()), labelUid)})), Set$.MODULE$.canBuildFrom())));
    }

    private Seq<Object> updateEnvToLabelReferences(Environment environment, Integer environmentUid) {
        Map<String, Integer> labelIdsToUids = this.getLabelUids(environment);
        String deleteEnvToLabelRefsStmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |DELETE FROM ", "\n         | WHERE\n         | ", " = :", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE(), EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID(), EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()})))).stripMargin();
        this.sqlExec(deleteEnvToLabelRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid)})), x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.execute()));
        return this.insertEnvToLabelReferences(environmentUid, (Set<Integer>)labelIdsToUids.valuesIterator().toSet());
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> environmentIds) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|SELECT ", ", ", "\n          |FROM ", "\n          |WHERE ", " IN (:environmentIds)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()})))).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentIds"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)environmentIds.map((Function1 & Serializable & scala.Serializable)id -> package$.MODULE$.toPersistedId((String)id), Iterable$.MODULE$.canBuildFrom())).asJava())})), (Function1 & Serializable & scala.Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID())))).toMap(Predef$.MODULE$.$conforms());
    }

    private void sanitizeEnvironmentInput(Environment environment) {
        environment.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(environment.getTitle()), EnvironmentSchema$.MODULE$.TITLE_LENGTH()));
        environment.setDescription(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(environment.getDescription()), EnvironmentSchema$.MODULE$.DESCRIPTION_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$2(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$3(ResultSet x$3) {
        return x$3.getInt(1) > 0;
    }

    @Autowired
    public EnvironmentPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, SecurablePersistence securablePersistence, EnvironmentStagePersistence environmentStagePersistence, EnvironmentLabelPersistence environmentLabelPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.securablePersistence = securablePersistence;
        this.environmentStagePersistence = environmentStagePersistence;
        this.environmentLabelPersistence = environmentLabelPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_ENVIRONMENTS = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |INSERT INTO ", "\n       |(", ",\n       |", ",\n       |", ",\n       |", ",\n       |", ")\n       |VALUES\n       |(:", ",\n       |:", ",\n       |:", ",\n       |:", ",\n       |:", ")\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID()})))).stripMargin();
        this.STMT_EXISTS_BY_TITLE_IGNORECASE = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT COUNT(*) FROM ", " WHERE LOWER(", ") = LOWER(:", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()}));
        this.STMT_UPDATE_ENVIRONMENTS = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|UPDATE ", "\n        | SET\n        |  ", " = :", ",\n        |  ", " = :", ",\n        |  ", " = :", "\n        | WHERE\n        |  ", " = :", "\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.DESCRIPTION(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()})))).stripMargin();
        this.STMT_EXISTS_ANOTHER_ENV_WITH_TITLE = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", "\n       |AND ", " <> :", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.STMT_EXISTS_BY_TITLE_IGNORECASE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID()})))).stripMargin();
        this.STMT_DELETE_ENVIRONMENTS_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|DELETE FROM ", "\n        | WHERE ", " = :environmentId"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE(), EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID()})))).stripMargin();
    }
}

