/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import com.xebialabs.xlrelease.environments.service.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\t\u0012\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003<\u0001\u0011\u0005A\bC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l\tiRI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|gnU3sm&\u001cWM\u0003\u0002\u0013'\u000591/\u001a:wS\u000e,'B\u0001\u000b\u0016\u00031)gN^5s_:lWM\u001c;t\u0015\t1r#A\u0005yYJ,G.Z1tK*\u0011\u0001$G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AG\u0001\u0004G>l7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005)1\u000f\u001c45U*\t\u0001&\u0001\u0005he&T(\u0010\\3e\u0013\tQSEA\u0004M_\u001e<\u0017N\\4\u0002A\u0015tg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003[Aj\u0011A\f\u0006\u0003_M\t!B]3q_NLGo\u001c:z\u0013\t\tdF\u0001\u0011F]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o%\u0016\u0004xn]5u_JL\u0018AE3om&\u0014xN\\7f]R\u001cVM\u001d<jG\u0016\u0004\"\u0001N\u001b\u000e\u0003EI!AN\t\u0003%\u0015sg/\u001b:p]6,g\u000e^*feZL7-Z\u0001\u0013CB\u0004H.[2bi&|gnU3sm&\u001cW\r\u0005\u00025s%\u0011!(\u0005\u0002\u0013\u0003B\u0004H.[2bi&|gnU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005{yz\u0004\t\u0005\u00025\u0001!)1\u0006\u0002a\u0001Y!)!\u0007\u0002a\u0001g!)q\u0007\u0002a\u0001q!\u0012AA\u0011\t\u0003\u0007:k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b!\"\u00198o_R\fG/[8o\u0015\t9\u0005*A\u0004gC\u000e$xN]=\u000b\u0005%S\u0015!\u00022fC:\u001c(BA&M\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\t\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0013g\u0016\f'o\u00195SKN,'O^1uS>t7\u000f\u0006\u0002SOB!1\u000b\u0017.b\u001b\u0005!&BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\u0004\u001b\u0006\u0004\bCA.`\u001b\u0005a&B\u0001\u000b^\u0015\tqV#\u0001\u0004e_6\f\u0017N\\\u0005\u0003Ar\u00131\"\u00128wSJ|g.\\3oiB\u00191K\u00193\n\u0005\r$&\u0001\u0002'jgR\u0004\"aW3\n\u0005\u0019d&AF#om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8\t\u000b!,\u0001\u0019A5\u0002\u000f\u0019LG\u000e^3sgB\u0011!.]\u0007\u0002W*\u0011A.\\\u0001\u0007M&dG/\u001a:\u000b\u00059|\u0017A\u0001<2\u0015\t\u0001X#A\u0002ba&L!A]6\u0003%I+7/\u001a:wCRLwN\u001c$jYR,'o\u001d\u0015\u0003\u000bQ\u0004\"!^>\u000e\u0003YT!!R<\u000b\u0005aL\u0018aB7fiJL7m\u001d\u0006\u0003uf\t\u0001bY8eC\"\fG.Z\u0005\u0003yZ\u0014Q\u0001V5nK\u0012\f1CZ5oIJ+7/\u001a:wCRLwN\u001c\"z\u0013\u0012$\"\u0001Z@\t\u000f\u0005\u0005a\u00011\u0001\u0002\u0004\u0005ARM\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|g.\u00133\u0011\t\u0005\u0015\u00111\u0003\b\u0005\u0003\u000f\ty\u0001E\u0002\u0002\n}i!!a\u0003\u000b\u0007\u000551$\u0001\u0004=e>|GOP\u0005\u0004\u0003#y\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005]!AB*ue&twMC\u0002\u0002\u0012}A#A\u0002;\u0002=\u001d,GOU3tKJ4\u0018\r^5p]N\u0014\u00150\u00128wSJ|g.\\3oi&#GcA1\u0002 !9\u0011\u0011E\u0004A\u0002\u0005\r\u0011!D3om&\u0014xN\\7f]RLE\r\u000b\u0002\bi\u0006\t2M]3bi\u0016\u0014Vm]3sm\u0006$\u0018n\u001c8\u0015\u0007\u0011\fI\u0003\u0003\u0004\u0002,!\u0001\r\u0001Z\u0001\u0017K:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]\"\u0012\u0001\u0002^\u0001\u0012kB$\u0017\r^3SKN,'O^1uS>tGc\u00013\u00024!1\u00111F\u0005A\u0002\u0011D#!\u0003;\u0002#\u0011,G.\u001a;f%\u0016\u001cXM\u001d<bi&|g\u000e\u0006\u0003\u0002<\u0005\u0005\u0003c\u0001\u0010\u0002>%\u0019\u0011qH\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003Q\u0001\u0019AA\u0002Q\tQA/A\tfq&\u001cHo\u001d*fg\u0016\u0014h/\u0019;j_:$b!!\u0013\u0002P\u0005E\u0003c\u0001\u0010\u0002L%\u0019\u0011QJ\u0010\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011E\u0006A\u0002\u0005\r\u0001bBA*\u0017\u0001\u0007\u00111A\u0001\u000eCB\u0004H.[2bi&|g.\u00133)\u0005-!\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\t\u0005m\u00121\f\u0005\u0007\u0003Wa\u0001\u0019\u00013\u0002\u001bY\fG.\u001b3bi\u0016$\u0015\r^3t)\u0011\tY$!\u0019\t\r\u0005-R\u00021\u0001e\u000311\u0018\r\\5eCR,gj\u001c;f)\u0011\tY$a\u001a\t\r\u0005-b\u00021\u0001e\u0003Q1\u0018\r\\5eCR,\u0017\t\u001d9mS\u000e\fG/[8ogR!\u00111HA7\u0011\u0019\tYc\u0004a\u0001I\"\u001a\u0001!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001eK\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003w\n)HA\u0004TKJ4\u0018nY3")
public class EnvironmentReservationService
implements Logging {
    private final EnvironmentReservationRepository environmentReservationRepository;
    private final ApplicationService applicationService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentReservationService environmentReservationService = this;
        synchronized (environmentReservationService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public java.util.Map<Environment, List<EnvironmentReservation>> searchReservations(ReservationFilters filters) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.environmentReservationRepository.search(filters, package$.MODULE$.defaultPage()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava())).asJava();
    }

    @Timed
    public EnvironmentReservation findReservationById(String environmentReservationId) {
        return this.environmentReservationRepository.findById(environmentReservationId);
    }

    @Timed
    public List<EnvironmentReservation> getReservationsByEnvironmentId(String environmentId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentReservationRepository.getAllForEnvironmentId(environmentId)).asJava();
    }

    @Timed
    public EnvironmentReservation createReservation(EnvironmentReservation environmentReservation) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating a new environment reservation");
        this.validate(environmentReservation);
        return this.environmentReservationRepository.create(environmentReservation);
    }

    @Timed
    public EnvironmentReservation updateReservation(EnvironmentReservation environmentReservation) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Updating environment reservation [").append((Object)environmentReservation).append("]").toString());
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentReservation);
        return this.environmentReservationRepository.update(environmentReservation);
    }

    @Timed
    public void deleteReservation(String environmentReservationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Deleting environment reservation [").append(environmentReservationId).append("]").toString());
        this.environmentReservationRepository.delete(environmentReservationId);
    }

    @Timed
    public boolean existsReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Checking reservation for environmentId [").append(environmentId).append("] and applicationId [").append(applicationId).append("]").toString());
        return this.environmentReservationRepository.existsByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date());
    }

    private void validate(EnvironmentReservation environmentReservation) {
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environmentReservation.getEnvironment()).exists((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationService.$anonfun$validate$1(env))), (String)"Environment ID is required", (Object[])new Object[0]);
        this.validateDates(environmentReservation);
        this.validateNote(environmentReservation);
        this.validateApplications(environmentReservation);
    }

    private void validateDates(EnvironmentReservation environmentReservation) {
        Date startDate = environmentReservation.getStartDate();
        Date endDate = environmentReservation.getEndDate();
        Checks.checkArgument((startDate != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((endDate != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)startDate.before(endDate), (String)"Start date must be before the end date", (Object[])new Object[0]);
    }

    private void validateNote(EnvironmentReservation environmentReservation) {
        block0: {
            if (environmentReservation.getNote() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getNote()), (String)"Note cannot be blank", (Object[])new Object[0]);
        }
    }

    private void validateApplications(EnvironmentReservation environmentReservation) {
        if (CollectionUtils.isNotEmpty(environmentReservation.getApplications())) {
            Set allowedAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.applicationService.getApplicationsDeployableOnEnvironment(environmentReservation.getEnvironment().getId())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set givenAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environmentReservation.getApplications()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set diff = (Set)givenAppIds.diff((GenSet)allowedAppIds);
            if (diff.nonEmpty()) {
                Tuple2 tuple2 = diff.splitAt(10);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Set first10 = (Set)tuple2._1();
                Set rest = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)first10, (Object)rest);
                Tuple2 tuple23 = tuple22;
                Set first102 = (Set)tuple23._1();
                Set rest2 = (Set)tuple23._2();
                throw new Checks.IncorrectArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n             |The following applications are not deployable on environment [").append(environmentReservation.getEnvironment().getId()).append("]:\n             |[").append(first102.mkString(", ")).append("] ").append((Object)(rest2.nonEmpty() ? ", and more" : BoxedUnit.UNIT)).append("\n             |").toString())).stripMargin(), new Object[0]);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Environment env) {
        return StringUtils.hasText((String)env.getId());
    }

    @Autowired
    public EnvironmentReservationService(EnvironmentReservationRepository environmentReservationRepository, EnvironmentService environmentService, ApplicationService applicationService) {
        this.environmentReservationRepository = environmentReservationRepository;
        this.applicationService = applicationService;
        Logging.$init$((Logging)this);
    }
}

