/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.Mappers$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ApplicationSqlBuilder$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecurablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0011#\u0001EB\u0001b\u0010\u0001\u0003\u0006\u0004%\u0019\u0001\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0003\"Aa\n\u0001BC\u0002\u0013\rq\n\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003Q\u0011!A\u0007A!b\u0001\n\u0007I\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011E\u0004!Q1A\u0005\u0002ID\u0001b\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tq\u0002\u0011)\u0019!C\u0001s\"AQ\u0010\u0001B\u0001B\u0003%!\u0010C\u0003\u007f\u0001\u0011\u0005q\u0010C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u0011Q\n\u0001!\u0002\u0013\ti\u0004C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002<!A\u0011\u0011\u000b\u0001!\u0002\u0013\ti\u0004C\u0004\u0002T\u0001!\t!!\u0016\t\u0013\u0005\r\u0005A1A\u0005\n\u0005m\u0002\u0002CAC\u0001\u0001\u0006I!!\u0010\t\u0013\u0005\u001d\u0005A1A\u0005\n\u0005m\u0002\u0002CAE\u0001\u0001\u0006I!!\u0010\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"I\u0011q\u0013\u0001C\u0002\u0013%\u00111\b\u0005\t\u00033\u0003\u0001\u0015!\u0003\u0002>!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!a<\u0001\t\u0003\t\t\u0010C\u0004\u0003\n\u0001!IAa\u0003\t\u000f\t=\u0001\u0001\"\u0003\u0003\u0012!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0002\u0017\u0003B\u0004H.[2bi&|g\u000eU3sg&\u001cH/\u001a8dK*\u00111\u0005J\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0011FK\u0001\rK:4\u0018N]8o[\u0016tGo\u001d\u0006\u0003W1\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00055r\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005y\u0013aA2p[\u000e\u00011c\u0001\u00013qA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\u0004\"!O\u001f\u000e\u0003iR!aI\u001e\u000b\u0005\u0015b$BA\u0014+\u0013\tq$H\u0001\nQKJ\u001c\u0018n\u001d;f]\u000e,7+\u001e9q_J$\u0018\u0001\u00046eE\u000e$V-\u001c9mCR,W#A!\u0011\u0005\t[U\"A\"\u000b\u0005\u0011+\u0015\u0001B2pe\u0016T!AR$\u0002\t)$'m\u0019\u0006\u0003\u0011&\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u001b%\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017!\u00046eE\u000e$V-\u001c9mCR,\u0007%A\u0004eS\u0006dWm\u0019;\u0016\u0003A\u0003\"!\u00153\u000f\u0005I\u000bgBA*`\u001d\t!VL\u0004\u0002V9:\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033B\na\u0001\u0010:p_Rt\u0014\"A\u0018\n\u00055r\u0013BA\u0016-\u0013\tq&&\u0001\u0002eE&\u0011Q\u0005\u0019\u0006\u0003=*J!AY2\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002&A&\u0011QM\u001a\u0002\b\t&\fG.Z2u\u0015\t\u00117-\u0001\u0005eS\u0006dWm\u0019;!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0016\u0002\u000fM,'O^5dK&\u0011q\u000e\u001c\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\ff]ZL'o\u001c8nK:$\b+\u001a:tSN$XM\\2f+\u0005\u0019\bC\u0001;v\u001b\u0005\u0011\u0013B\u0001<#\u0005Y)eN^5s_:lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aF3om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3!\u0003Q\u0019XmY;sC\ndW\rU3sg&\u001cH/\u001a8dKV\t!\u0010\u0005\u0002:w&\u0011AP\u000f\u0002\u0015'\u0016\u001cWO]1cY\u0016\u0004VM]:jgR,gnY3\u0002+M,7-\u001e:bE2,\u0007+\u001a:tSN$XM\\2fA\u00051A(\u001b8jiz\"\"!!\u0001\u0015\u0019\u0005\r\u0011QAA\u0012\u0003W\ti#a\f\u0011\u0005Q\u0004\u0001\"B \f\u0001\b\t\u0005\u0006CA\u0003\u0003\u0013\ti\"a\b\u0011\t\u0005-\u0011\u0011D\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005M\u0011QC\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\t9bR\u0001\u0006E\u0016\fgn]\u0005\u0005\u00037\tiAA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\u0012\u0011\u0011E\u0001\u001aq2\u0014(+\u001a9pg&$xN]=KI\n\u001cG+Z7qY\u0006$X\rC\u0003O\u0017\u0001\u000f\u0001\u000b\u000b\u0005\u0002$\u0005%\u0011QDA\u0014C\t\tI#A\fyYJ\u0014V\r]8tSR|'/_*rY\u0012K\u0017\r\\3di\")\u0001n\u0003a\u0002U\")\u0011o\u0003a\u0001g\")\u0001p\u0003a\u0001u\"\u001a1\"a\r\u0011\t\u0005-\u0011QG\u0005\u0005\u0003o\tiAA\u0005BkR|w/\u001b:fI\u0006A2\u000bV'U?&s5+\u0012*U?\u0006\u0003\u0006\u000bT%D\u0003RKuJT*\u0016\u0005\u0005u\u0002\u0003BA \u0003\u000frA!!\u0011\u0002DA\u0011q\u000bN\u0005\u0004\u0003\u000b\"\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002J\u0005-#AB*ue&twMC\u0002\u0002FQ\n\u0011d\u0015+N)~KejU#S)~\u000b\u0005\u000b\u0015'J\u0007\u0006#\u0016j\u0014(TA\u0005y2\u000bV'U?\u0016C\u0016j\u0015+T?\nKv\fV%U\u0019\u0016{\u0016j\u0012(P%\u0016\u001b\u0015iU#\u0002AM#V\nV0F1&\u001bFkU0C3~#\u0016\n\u0016'F?&;ej\u0014*F\u0007\u0006\u001bV\tI\u0001\u0007S:\u001cXM\u001d;\u0015\t\u0005]\u0013\u0011\u000f\t\u0005\u00033\nYG\u0004\u0003\u0002\\\u0005\u001dd\u0002BA/\u0003KrA!a\u0018\u0002d9\u0019A+!\u0019\n\u0005\u001dR\u0013BA\u0013=\u0013\t\u00193(C\u0002\u0002ji\nAaQ5JI&!\u0011QNA8\u0005\u0011\u0019\u0015.\u00133\u000b\u0007\u0005%$\bC\u0004\u0002tA\u0001\r!!\u001e\u0002\u0017\u0005\u0004\b\u000f\\5dCRLwN\u001c\t\u0005\u0003o\ny(\u0004\u0002\u0002z)\u0019\u0011&a\u001f\u000b\u0007\u0005u$&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u0003\u000bIHA\u0006BaBd\u0017nY1uS>t\u0017\u0001G*U\u001bR{V\u000b\u0015#B)\u0016{\u0016\t\u0015)M\u0013\u000e\u000bE+S(O'\u0006I2\u000bV'U?V\u0003F)\u0011+F?\u0006\u0003\u0006\u000bT%D\u0003RKuJT*!\u0003\t\u001aF+\u0014+`\u000bbK5\u000bV*`\u0003:{E\u000bS#S?\u0006\u0003\u0006kX,J)\"{F+\u0013+M\u000b\u0006\u00193\u000bV'U?\u0016C\u0016j\u0015+T?\u0006su\n\u0016%F%~\u000b\u0005\u000bU0X\u0013RCu\fV%U\u0019\u0016\u0003\u0013AB;qI\u0006$X\r\u0006\u0003\u0002\u0010\u0006U\u0005cA\u001a\u0002\u0012&\u0019\u00111\u0013\u001b\u0003\u000f\t{w\u000e\\3b]\"9\u00111O\u000bA\u0002\u0005U\u0014AH*U\u001bR{F)\u0012'F)\u0016{\u0016\t\u0015)M\u0013\u000e\u000bE+S(O'~\u0013\u0015lX%E\u0003}\u0019F+\u0014+`\t\u0016cU\tV#`\u0003B\u0003F*S\"B)&{ejU0C3~KE\tI\u0001\u0007I\u0016dW\r^3\u0015\t\u0005}\u00151\u0016\t\u0007\u0003C\u000b9+a$\u000e\u0005\u0005\r&bAASi\u0005!Q\u000f^5m\u0013\u0011\tI+a)\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002.b\u0001\r!a\u0016\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0003!1\u0017N\u001c3Cs&#G\u0003BAZ\u0003s\u0003RaMA[\u0003kJ1!a.5\u0005\u0019y\u0005\u000f^5p]\"9\u0011QV\rA\u0002\u0005]\u0013a\u00034j]\u0012,\u0016\u000e\u001a\"z\u0013\u0012$B!a0\u0002PB)1'!.\u0002BB!\u00111YAe\u001d\u0011\tY&!2\n\u0007\u0005\u001d'(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0017Q\u001a\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0004\u0003\u000fT\u0004bBAW5\u0001\u0007\u0011qK\u0001\rO\u0016$X+\u001b3t\u0005fLEm\u001d\u000b\u0005\u0003+\fY\u000e\u0005\u0005\u0002@\u0005]\u0017qKAa\u0013\u0011\tI.a\u0013\u0003\u00075\u000b\u0007\u000fC\u0004\u0002^n\u0001\r!a8\u0002\u001d\u0005\u0004\b\u000f\\5dCRLwN\\%egB1\u0011\u0011]Au\u0003/rA!a9\u0002h:\u0019q+!:\n\u0003UJ1!a25\u0013\u0011\tY/!<\u0003\u0011%#XM]1cY\u0016T1!a25\u0003\u0019\u0019X-\u0019:dQR!\u00111_A}!\u0019\t\t/!>\u0002v%!\u0011q_Aw\u0005\r\u0019V-\u001d\u0005\b\u0003wd\u0002\u0019AA\u007f\u0003E\u0019\u0018\u000f\\,ji\"\u0004\u0016M]1nKR,'o\u001d\t\u0005\u0003\u007f\u0014\u0019AD\u0002S\u0005\u0003I1!a2d\u0013\u0011\u0011)Aa\u0002\u0003#M\u000bHnV5uQB\u000b'/Y7fi\u0016\u00148OC\u0002\u0002H\u000e\f!cZ3u\u000b:4\u0018N]8o[\u0016tG/V5egR!\u0011Q\u001bB\u0007\u0011\u001d\t\u0019(\ba\u0001\u0003k\n\u0001$\u001b8tKJ$\u0018\t\u001d9U_\u0016sgOU3gKJ,gnY3t)\u0019\u0011\u0019B!\u0007\u0003\u001eA\u00191G!\u0006\n\u0007\t]AG\u0001\u0003V]&$\bb\u0002B\u000e=\u0001\u0007\u0011\u0011Y\u0001\u000fCB\u0004H.[2bi&|g.V5e\u0011\u001d\u0011yB\ba\u0001\u0005C\tq!\u001a8w+&$7\u000f\u0005\u0004\u0002@\t\r\u0012\u0011Y\u0005\u0005\u0005K\tYEA\u0002TKR\f\u0001$\u001e9eCR,\u0017\t\u001d9U_\u0016sgOU3gKJ,gnY3t)\u0019\u0011\u0019Ba\u000b\u0003.!9\u00111O\u0010A\u0002\u0005U\u0004b\u0002B\u000e?\u0001\u0007\u0011\u0011Y\u0001\u0019g\u0006t\u0017\u000e^5{K\u0006\u0003\b\u000f\\5dCRLwN\\%oaV$H\u0003\u0002B\n\u0005gAq!a\u001d!\u0001\u0004\t)\bK\u0002\u0001\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0004\u0005{\u0019\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:LAA!\u0011\u0003<\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eK\u0002\u0001\u0005\u000b\u0002BAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u0017:\u0015AC:uKJ,w\u000e^=qK&!!q\nB%\u0005)\u0011V\r]8tSR|'/\u001f\u0015\b\u0001\tM\u0013Q\u0004B1!\u0011\u0011)F!\u0018\u000e\u0005\t]#\u0002BA\b\u00053R1Aa\u0017H\u0003\u001d\u0019wN\u001c;fqRLAAa\u0018\u0003X\t9\u0001K]8gS2,GF\u0001B2C\u0005)\u0003")
public class ApplicationPersistence
implements PersistenceSupport {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentPersistence environmentPersistence;
    private final SecurablePersistence securablePersistence;
    private final String STMT_INSERT_APPLICATIONS;
    private final String STMT_EXISTS_BY_TITLE_IGNORECASE;
    private final String STMT_UPDATE_APPLICATIONS;
    private final String STMT_EXISTS_ANOTHER_APP_WITH_TITLE;
    private final String STMT_DELETE_APPLICATIONS_BY_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, Map<String, Object> params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        ApplicationPersistence applicationPersistence = this;
        synchronized (applicationPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EnvironmentPersistence environmentPersistence() {
        return this.environmentPersistence;
    }

    public SecurablePersistence securablePersistence() {
        return this.securablePersistence;
    }

    private String STMT_INSERT_APPLICATIONS() {
        return this.STMT_INSERT_APPLICATIONS;
    }

    private String STMT_EXISTS_BY_TITLE_IGNORECASE() {
        return this.STMT_EXISTS_BY_TITLE_IGNORECASE;
    }

    public String insert(Application application) {
        this.sanitizeApplicationInput(application);
        boolean exists = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_BY_TITLE_IGNORECASE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentSchema$ENVIRONMENTS$.MODULE$.TITLE()), (Object)application.getTitle())})), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$insert$1(x$1))).head());
        if (exists) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Application with title '").append(application.getTitle()).append("' already exists").toString());
        }
        Map<String, Integer> environmentUids = this.getEnvironmentUids(application);
        Integer ciUid = this.securablePersistence().insert();
        String appId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(Application.class), this.ciIdService());
        String displayedAppId = package$.MODULE$.toDisplayId(appId);
        try {
            this.sqlExec(this.STMT_INSERT_APPLICATIONS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)appId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
        }
        catch (DuplicateKeyException ex) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Application with ID '").append(displayedAppId).append("' already exists").toString(), ex);
        }
        this.insertAppToEnvReferences(ciUid, (Set<Integer>)environmentUids.valuesIterator().toSet());
        return displayedAppId;
    }

    private String STMT_UPDATE_APPLICATIONS() {
        return this.STMT_UPDATE_APPLICATIONS;
    }

    private String STMT_EXISTS_ANOTHER_APP_WITH_TITLE() {
        return this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE;
    }

    public boolean update(Application application) {
        Integer applicationUid = (Integer)this.findUidById(application.getId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Application [").append(application.getId()).append("] not found").toString(), new Object[0]);
        });
        this.sanitizeApplicationInput(application);
        boolean existsAnotherWithSameTitle = BoxesRunTime.unboxToBoolean((Object)this.sqlQuery(this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid)})), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ApplicationPersistence.$anonfun$update$2(x$3))).head());
        if (existsAnotherWithSameTitle) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Application with title '").append(application.getTitle()).append("' already exists").toString());
        }
        this.updateAppToEnvReferences(application, applicationUid);
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_APPLICATIONS(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()), (Object)application.getTitle())})), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 == 1));
    }

    private String STMT_DELETE_APPLICATIONS_BY_ID() {
        return this.STMT_DELETE_APPLICATIONS_BY_ID;
    }

    public Try<Object> delete(String applicationId) {
        return (Try)this.sqlExec(this.STMT_DELETE_APPLICATIONS_BY_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ps.execute()));
    }

    public Option<Application> findById(String applicationId) {
        Tuple2<String, Seq<Object>> tuple2 = ApplicationSqlBuilder$.MODULE$.apply(ApplicationSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).select().withApplicationId(package$.MODULE$.toPersistedId(applicationId)).build();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Option)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationResultSetExtractor());
    }

    public Option<Integer> findUidById(String applicationId) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("|SELECT ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n          |FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n          |WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).toString())).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(applicationId))})), (Function1 & Serializable & scala.Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()))).headOption();
    }

    public Map<String, Integer> getUidsByIds(Iterable<String> applicationIds) {
        String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("|SELECT ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append(", ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n          |FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n          |WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" IN (:applicationIds)\n       ").toString())).stripMargin();
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationIds"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)applicationIds.map((Function1 & Serializable & scala.Serializable)id -> package$.MODULE$.toPersistedId((String)id), Iterable$.MODULE$.canBuildFrom())).asJava())})), (Function1 & Serializable & scala.Serializable)rs -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ResultSetExtension((ResultSet)rs).getCiId(ApplicationSchema$APPLICATIONS$.MODULE$.ID())), (Object)package.CiUid$.MODULE$.apply(rs.getInt(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID())))).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Application> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        Tuple2 tuple23 = tuple22;
        String sql2 = (String)tuple23._1();
        Seq params2 = (Seq)tuple23._2();
        return (Seq)this.jdbcTemplate().query(sql2, (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()), Mappers$.MODULE$.applicationSearchResultSetExtractor());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Integer> getEnvironmentUids(Application application) {
        Map map;
        if (CollectionUtils.isEmpty(application.getEnvironments())) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            void var3_3;
            Map<String, Integer> environmentIdsToUids;
            Set environmentIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(application.getEnvironments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set environmentDiff = (Set)environmentIds.diff((GenSet)(environmentIdsToUids = this.environmentPersistence().getUidsByIds((Iterable<String>)environmentIds)).keySet());
            if (environmentDiff.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(25).append("Environments [").append(environmentDiff.mkString(", ")).append("] not found").toString(), new Object[0]);
            }
            map = var3_3;
        }
        return map;
    }

    private void insertAppToEnvReferences(Integer applicationUid, Set<Integer> envUids) {
        String insertAppTpEnvStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("INSERT INTO ").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE()).append(" (\n         |").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append(",\n         |").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()).append("\n         |)\n         |VALUES (\n         |:").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append(",\n         |:").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()).append("\n         |)\n       ").toString())).stripMargin();
        this.sqlBatch(insertAppTpEnvStmt, (Set<Map<String, Object>>)((Set)envUids.map((Function1 & Serializable & scala.Serializable)envUid -> Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.ENVIRONMENT_UID()), envUid)})), Set$.MODULE$.canBuildFrom())));
    }

    private void updateAppToEnvReferences(Application application, Integer applicationUid) {
        Map<String, Integer> envIdsToUids = this.getEnvironmentUids(application);
        String deleteAppToEnvRefsStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |DELETE FROM ").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.TABLE()).append("\n         | WHERE\n         | ").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append(" = :").append(ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()).append("\n       ").toString())).stripMargin();
        this.sqlExec(deleteAppToEnvRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationSchema$APPLICATION_TO_ENVIRONMENTS$.MODULE$.APPLICATION_UID()), (Object)applicationUid)})), x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.execute()));
        this.insertAppToEnvReferences(applicationUid, (Set<Integer>)envIdsToUids.valuesIterator().toSet());
    }

    private void sanitizeApplicationInput(Application application) {
        application.setTitle(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(application.getTitle()), ApplicationSchema$.MODULE$.TITLE_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$insert$1(ResultSet x$1) {
        return x$1.getInt(1) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$update$2(ResultSet x$3) {
        return x$3.getInt(1) > 0;
    }

    @Autowired
    public ApplicationPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, EnvironmentPersistence environmentPersistence, SecurablePersistence securablePersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentPersistence = environmentPersistence;
        this.securablePersistence = securablePersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        this.STMT_INSERT_APPLICATIONS = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("|INSERT INTO ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        |   ( ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n        |   , ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n        |   , ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append("\n        |   )\n        | VALUES\n        |   ( :").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n        |   , :").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n        |   , :").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append("\n        |   )\n        ").toString())).stripMargin();
        this.STMT_EXISTS_BY_TITLE_IGNORECASE = new StringBuilder(46).append("SELECT COUNT(*) FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append(" WHERE LOWER(").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(") = LOWER(:").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(")").toString();
        this.STMT_UPDATE_APPLICATIONS = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("|UPDATE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        | SET\n        |  ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append("\n        | WHERE\n        |  ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n       ").toString())).stripMargin();
        this.STMT_EXISTS_ANOTHER_APP_WITH_TITLE = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("|SELECT COUNT(*)\n        |FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        |WHERE LOWER(").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(") = LOWER(:").append(ApplicationSchema$APPLICATIONS$.MODULE$.TITLE()).append(")\n        |AND ").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append(" <> :").append(ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID()).append("\n       ").toString())).stripMargin();
        this.STMT_DELETE_APPLICATIONS_BY_ID = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(42).append("|DELETE FROM ").append(ApplicationSchema$APPLICATIONS$.MODULE$.TABLE()).append("\n        | WHERE ").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append(" = :").append(ApplicationSchema$APPLICATIONS$.MODULE$.ID()).append("\n       ").toString())).stripMargin();
    }
}

