/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002|\u0001!I!! \u0003;\u0015sg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:\u001cVM\u001d<jG\u0016T!a\u0005\u000b\u0002\u000fM,'O^5dK*\u0011QCF\u0001\rK:4\u0018N]8o[\u0016tGo\u001d\u0006\u0003/a\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003%\n\u0001b\u001a:jujdW\rZ\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\u0011f]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0015\u0003)\u0011X\r]8tSR|'/_\u0005\u0003e=\u0012\u0001%\u00128wSJ|g.\\3oiJ+7/\u001a:wCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0011RM\u001c<je>tW.\u001a8u'\u0016\u0014h/[2f!\t)d'D\u0001\u0013\u0013\t9$C\u0001\nF]ZL'o\u001c8nK:$8+\u001a:wS\u000e,\u0017AE1qa2L7-\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"!\u000e\u001e\n\u0005m\u0012\"AE!qa2L7-\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001Z\ta!\u001a<f]R\u001c\u0018B\u0001\"@\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u00153u\tS%\u0011\u0005U\u0002\u0001\"\u0002\u0017\u0006\u0001\u0004i\u0003\"B\u001a\u0006\u0001\u0004!\u0004\"\u0002\u001d\u0006\u0001\u0004I\u0004\"\u0002\u001f\u0006\u0001\u0004i\u0004FA\u0003L!\tau+D\u0001N\u0015\tqu*\u0001\u0006b]:|G/\u0019;j_:T!\u0001U)\u0002\u000f\u0019\f7\r^8ss*\u0011!kU\u0001\u0006E\u0016\fgn\u001d\u0006\u0003)V\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002-\u0006\u0019qN]4\n\u0005ak%!C!vi><\u0018N]3e\u0003I\u0019X-\u0019:dQJ+7/\u001a:wCRLwN\\:\u0015\u0005m\u0003\b\u0003\u0002/bG*l\u0011!\u0018\u0006\u0003=~\u000bA!\u001e;jY*\t\u0001-\u0001\u0003kCZ\f\u0017B\u00012^\u0005\ri\u0015\r\u001d\t\u0003I\"l\u0011!\u001a\u0006\u0003+\u0019T!a\u001a\f\u0002\r\u0011|W.Y5o\u0013\tIWMA\u0006F]ZL'o\u001c8nK:$\bc\u0001/l[&\u0011A.\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002e]&\u0011q.\u001a\u0002\u0017\u000b:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]\")\u0011O\u0002a\u0001e\u00069a-\u001b7uKJ\u001c\bCA:{\u001b\u0005!(BA;w\u0003\u00191\u0017\u000e\u001c;fe*\u0011q\u000f_\u0001\u0003mFR!!\u001f\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002|i\n\u0011\"+Z:feZ\fG/[8o\r&dG/\u001a:tQ\t1Q\u0010E\u0002\u007f\u0003\u0013i\u0011a \u0006\u0004\u001d\u0006\u0005!\u0002BA\u0002\u0003\u000b\tq!\\3ue&\u001c7OC\u0002\u0002\bi\t\u0001bY8eC\"\fG.Z\u0005\u0004\u0003\u0017y(!\u0002+j[\u0016$\u0017a\u00054j]\u0012\u0014Vm]3sm\u0006$\u0018n\u001c8Cs&#GcA7\u0002\u0012!9\u00111C\u0004A\u0002\u0005U\u0011\u0001G3om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8JIB!\u0011qCA\u0013\u001d\u0011\tI\"!\t\u0011\u0007\u0005m\u0001%\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u000f\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0003I\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r\u0002\u0005\u000b\u0002\b{\u0006qr-\u001a;SKN,'O^1uS>t7OQ=F]ZL'o\u001c8nK:$\u0018\n\u001a\u000b\u0004U\u0006E\u0002bBA\u001a\u0011\u0001\u0007\u0011QC\u0001\u000eK:4\u0018N]8o[\u0016tG/\u00133)\u0005!i\u0018!E2sK\u0006$XMU3tKJ4\u0018\r^5p]R\u0019Q.a\u000f\t\r\u0005u\u0012\u00021\u0001n\u0003Y)gN^5s_:lWM\u001c;SKN,'O^1uS>t\u0007FA\u0005~\u0003E)\b\u000fZ1uKJ+7/\u001a:wCRLwN\u001c\u000b\u0004[\u0006\u0015\u0003BBA\u001f\u0015\u0001\u0007Q\u000e\u000b\u0002\u000b{\u0006\tB-\u001a7fi\u0016\u0014Vm]3sm\u0006$\u0018n\u001c8\u0015\t\u00055\u00131\u000b\t\u0004?\u0005=\u0013bAA)A\t!QK\\5u\u0011\u001d\t\u0019b\u0003a\u0001\u0003+A#aC?\u0002#\u0015D\u0018n\u001d;t%\u0016\u001cXM\u001d<bi&|g\u000e\u0006\u0004\u0002\\\u0005\u0005\u00141\r\t\u0004?\u0005u\u0013bAA0A\t9!i\\8mK\u0006t\u0007bBA\u001a\u0019\u0001\u0007\u0011Q\u0003\u0005\b\u0003Kb\u0001\u0019AA\u000b\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JI\"\u0012A\"`\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011QJA7\u0011\u0019\ti$\u0004a\u0001[\u0006ia/\u00197jI\u0006$X\rR1uKN$B!!\u0014\u0002t!1\u0011Q\b\bA\u00025\fAB^1mS\u0012\fG/\u001a(pi\u0016$B!!\u0014\u0002z!1\u0011QH\bA\u00025\fAC^1mS\u0012\fG/Z!qa2L7-\u0019;j_:\u001cH\u0003BA'\u0003\u007fBa!!\u0010\u0011\u0001\u0004i\u0007f\u0001\u0001\u0002\u0004B!\u0011QQAF\u001b\t\t9IC\u0002\u0002\nN\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ti)a\"\u0003\u000fM+'O^5dK\u0002")
public class EnvironmentReservationService
implements Logging {
    private final EnvironmentReservationRepository environmentReservationRepository;
    private final ApplicationService applicationService;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentReservationService environmentReservationService = this;
        synchronized (environmentReservationService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public java.util.Map<Environment, List<EnvironmentReservation>> searchReservations(ReservationFilters filters) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.environmentReservationRepository.search(filters, package$.MODULE$.defaultPage()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava())).asJava();
    }

    @Timed
    public EnvironmentReservation findReservationById(String environmentReservationId) {
        return this.environmentReservationRepository.findById(environmentReservationId);
    }

    @Timed
    public List<EnvironmentReservation> getReservationsByEnvironmentId(String environmentId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentReservationRepository.getAllForEnvironmentId(environmentId)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation createReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating a new environment reservation");
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.create(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationCreatedEvent(reservation));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation updateReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Updating environment reservation [").append((Object)environmentReservation).append("]").toString());
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.update(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationUpdatedEvent(reservation));
        return var2_2;
    }

    @Timed
    public void deleteReservation(String environmentReservationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Deleting environment reservation [").append(environmentReservationId).append("]").toString());
        EnvironmentReservation reservation = this.environmentReservationRepository.findById(environmentReservationId);
        this.environmentReservationRepository.delete(environmentReservationId);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationDeletedEvent(reservation));
    }

    @Timed
    public boolean existsReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Checking reservation for environmentId [").append(environmentId).append("] and applicationId [").append(applicationId).append("]").toString());
        return this.environmentReservationRepository.existsByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date());
    }

    private void validate(EnvironmentReservation environmentReservation) {
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environmentReservation.getEnvironment()).exists((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationService.$anonfun$validate$1(env))), (String)"Environment ID is required", (Object[])new Object[0]);
        this.validateDates(environmentReservation);
        this.validateNote(environmentReservation);
        this.validateApplications(environmentReservation);
    }

    private void validateDates(EnvironmentReservation environmentReservation) {
        Date startDate = environmentReservation.getStartDate();
        Date endDate = environmentReservation.getEndDate();
        Checks.checkArgument((startDate != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((endDate != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)startDate.before(endDate), (String)"Start date must be before the end date", (Object[])new Object[0]);
    }

    private void validateNote(EnvironmentReservation environmentReservation) {
        block0: {
            if (environmentReservation.getNote() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getNote()), (String)"Note cannot be blank", (Object[])new Object[0]);
        }
    }

    private void validateApplications(EnvironmentReservation environmentReservation) {
        if (CollectionUtils.isNotEmpty(environmentReservation.getApplications())) {
            Set allowedAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.applicationService.getApplicationsDeployableOnEnvironment(environmentReservation.getEnvironment().getId())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set givenAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environmentReservation.getApplications()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set diff = (Set)givenAppIds.diff((GenSet)allowedAppIds);
            if (diff.nonEmpty()) {
                Tuple2 tuple2 = diff.splitAt(10);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Set first10 = (Set)tuple2._1();
                Set rest = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)first10, (Object)rest);
                Tuple2 tuple23 = tuple22;
                Set first102 = (Set)tuple23._1();
                Set rest2 = (Set)tuple23._2();
                throw new Checks.IncorrectArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n             |The following applications are not deployable on environment [").append(environmentReservation.getEnvironment().getId()).append("]:\n             |[").append(first102.mkString(", ")).append("] ").append((Object)(rest2.nonEmpty() ? ", and more" : BoxedUnit.UNIT)).append("\n             |").toString())).stripMargin(), new Object[0]);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Environment env) {
        return StringUtils.hasText((String)env.getId());
    }

    @Autowired
    public EnvironmentReservationService(EnvironmentReservationRepository environmentReservationRepository, EnvironmentService environmentService, ApplicationService applicationService, XLReleaseEventBus eventBus) {
        this.environmentReservationRepository = environmentReservationRepository;
        this.applicationService = applicationService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

