/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.quartz.release.scheduler;

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import org.springframework.jmx.export.annotation.ManagedOperation;
import scala.Function0;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005=e!\u0002\u000e\u001c\u0003\u0003A\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011E\u0003!\u0011!Q\u0001\nIC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\t]\u0002\u0011\t\u0011)A\u0005_\")!\u000f\u0001C\u0001g\"9a\u0010\u0001a\u0001\n\u0013y\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011\u001d\ty\u0001\u0001Q!\n=D\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u000f\u0005U\u0001\u0001)A\u0005\r\"I\u0011q\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\b\u00033\u0001\u0001\u0015!\u0003G\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aa\u0001\b\u0001\u0007\u0002\u0005}\u0001BCA\u0014\u0001!\u0015\r\u0011\"\u0001\u0002*!Q\u0011\u0011\u0007\u0001\t\u0006\u0004%\t!a\r\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011q\b\u0001\u0005\u0002\u0005u\u0002bBA!\u0001\u0011%\u0011Q\b\u0005\b\u0003\u0007\u0002A\u0011BA\u001f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\u001c\u0001\t\u0003\ni\u0004C\u0004\u0002p\u0001!\t%!\u0010\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u0011Q\u000f\u0001\u0005B\u0005]$a\u0006\"bg\u0016tu\u000e^5gS\u000e\fG/[8o'\u0016\u0014h/[2f\u0015\taR$A\u0005tG\",G-\u001e7fe*\u0011adH\u0001\be\u0016dW-Y:f\u0015\t\u0001\u0013%\u0001\u0004rk\u0006\u0014HO\u001f\u0006\u0003E\r\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0011*\u0013!\u0003=fE&\fG.\u00192t\u0015\u00051\u0013aA2p[\u000e\u00011#\u0002\u0001*_]z\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021k5\t\u0011G\u0003\u00023g\u000511m\\7n_:T!\u0001N\u0011\u0002\u000fU\u0004xM]1eK&\u0011a'\r\u0002\u0012\u00072\f7o\u001d(b[\u0016$vn\u0015;sS:<\u0007C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0014\u0001C4sSjTH.\u001a3\n\u0005yJ$a\u0002'pO\u001eLgn\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0006\nqa]3sm&\u001cW-\u0003\u0002E\u0003\nqa)Z1ukJ,7+\u001a:wS\u000e,\u0017aC:feZL7-\u001a(b[\u0016\u0004\"a\u0012(\u000f\u0005!c\u0005CA%,\u001b\u0005Q%BA&(\u0003\u0019a$o\\8u}%\u0011QjK\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002NW\u0005A!n\u001c2DY\u0006T(\u0010\r\u0002T1B\u0019q\t\u0016,\n\u0005U\u0003&!B\"mCN\u001c\bCA,Y\u0019\u0001!\u0011\"\u0017\u0002\u0002\u0002\u0003\u0005)\u0011\u0001.\u0003\u0007}#\u0013'\u0005\u0002\\=B\u0011!\u0006X\u0005\u0003;.\u0012qAT8uQ&tw\r\u0005\u0002`G6\t\u0001M\u0003\u0002!C*\t!-A\u0002pe\u001eL!\u0001\u001a1\u0003\u0007){'-\u0001\feK\u001a\fW\u000f\u001c;Ue&<w-\u001a:J]R,'O^1m!\t9G.D\u0001i\u0015\tI'.\u0001\u0005ekJ\fG/[8o\u0015\tY7&\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u001c5\u0003\u0011\u0011+(/\u0019;j_:\f1C\\8uS\u001aL7-\u0019;j_:,e.\u00192mK\u0012\u0004\"A\u000b9\n\u0005E\\#a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bQ4x\u000f`?\u0011\u0005U\u0004Q\"A\u000e\t\u000b\u0015+\u0001\u0019\u0001$\t\u000bE+\u0001\u0019\u0001=1\u0005e\\\bcA$UuB\u0011qk\u001f\u0003\n3^\f\t\u0011!A\u0003\u0002iCQ!Z\u0003A\u0002\u0019DQA\\\u0003A\u0002=\fqA];o]&tw-F\u0001p\u0003-\u0011XO\u001c8j]\u001e|F%Z9\u0015\t\u0005\u0015\u00111\u0002\t\u0004U\u0005\u001d\u0011bAA\u0005W\t!QK\\5u\u0011!\tiaBA\u0001\u0002\u0004y\u0017a\u0001=%c\u0005A!/\u001e8oS:<\u0007%A\u0004k_\nt\u0015-\\3\u0016\u0003\u0019\u000b\u0001B[8c\u001d\u0006lW\rI\u0001\nOJ|W\u000f\u001d(b[\u0016\f!b\u001a:pkBt\u0015-\\3!\u0003=!(/[4hKJLe\u000e^3sm\u0006dW#\u00014\u0016\u0005\u0005\u0005\u0002cA0\u0002$%\u0019\u0011Q\u00051\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018a\u00016pEV\u0011\u00111\u0006\t\u0004?\u00065\u0012bAA\u0018A\nI!j\u001c2EKR\f\u0017\u000e\\\u0001\biJLwmZ3s+\t\t)\u0004E\u0002`\u0003oI1!!\u000fa\u00055\u0019\u0016.\u001c9mKR\u0013\u0018nZ4fe\u00061!/Z:v[\u0016$\"!!\u0002\u0002\u000bA\fWo]3\u0002\u0011M\u001c\u0007.\u001a3vY\u0016\f!\"\u001e8tG\",G-\u001e7f\u0003%ygn\u0015;beR,\b\u000f\u0006\u0003\u0002\u0006\u0005%\u0003bBA&+\u0001\u0007\u0011QJ\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111K\u0010\u0002\r\u00154XM\u001c;t\u0013\u0011\t9&!\u0015\u0003+M\u001b\u0007.\u001a3vY\u0016\u00148\u000b^1si\u0016$WI^3oi\"\u001aQ#a\u0017\u0011\t\u0005u\u0013\u0011N\u0007\u0003\u0003?RA!a\u0013\u0002b)!\u00111MA3\u0003\u001d\u0019wN\u001c;fqRT1!a\u001ab\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017\u0002BA6\u0003?\u0012Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\u0018AB3oC\ndW-A\u0004eSN\f'\r\\3\u0002\u0013%\u001cXI\\1cY\u0016$G#A8\u0002\t9\fW.\u001a\u000b\u0002\r\"\u001a\u0001!a\u001f\u0011\t\u0005u\u00141R\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006YAO]1og\u0006\u001cG/[8o\u0015\u0011\t))a\"\u0002\u0007M\fHNC\u0002\u0002\n\u0006\n!\u0001\u001a2\n\t\u00055\u0015q\u0010\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public abstract class BaseNotificationService
implements ClassNameToString,
Logging,
FeatureService {
    private JobDetail job;
    private SimpleTrigger trigger;
    private final String serviceName;
    private Class<? extends Job> jobClazz;
    private final Duration defaultTriggerInterval;
    private final boolean notificationEnabled;
    private boolean running;
    private final String jobName;
    private final String groupName;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @ManagedOperation(description="Stop service")
    public void stop() {
        super.stop();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public String toString() {
        return ClassNameToString.toString$((ClassNameToString)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private String jobName() {
        return this.jobName;
    }

    private String groupName() {
        return this.groupName;
    }

    public Duration triggerInterval() {
        return this.defaultTriggerInterval;
    }

    public abstract Scheduler scheduler();

    private JobDetail job$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.job = JobBuilder.newJob(this.jobClazz).withDescription(new StringBuilder(4).append(this.serviceName).append(" job").toString()).withIdentity(this.jobName(), this.groupName()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.jobClazz = null;
        return this.job;
    }

    public JobDetail job() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.job$lzycompute() : this.job;
    }

    private SimpleTrigger trigger$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(this.jobName(), this.groupName()).withDescription(new StringBuilder(13).append("Trigger ").append(this.serviceName).append(" jobs").toString()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.triggerInterval().toMillis()).repeatForever().withMisfireHandlingInstructionNowWithRemainingCount()).startNow().build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.trigger;
    }

    public SimpleTrigger trigger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.trigger$lzycompute() : this.trigger;
    }

    public void resume() {
        if (!this.running()) {
            this.scheduler().resumeJob(this.job().getKey());
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(16).append("Started ").append($this.serviceName).append(" service").toString());
        }
        this.running_$eq(true);
    }

    public void pause() {
        if (this.running()) {
            this.scheduler().pauseJob(this.job().getKey());
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(16).append("Stopped ").append($this.serviceName).append(" service").toString());
        }
        this.running_$eq(false);
    }

    private void schedule() {
        Date date;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Scheduled ").append($this.serviceName).append(" service").toString());
        if (this.scheduler().checkExists(this.trigger().getKey())) {
            date = this.scheduler().rescheduleJob(this.trigger().getKey(), (Trigger)this.trigger());
        } else {
            this.scheduler().scheduleJob(this.job(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleTrigger[]{this.trigger()}))).asJava(), true);
            date = BoxedUnit.UNIT;
        }
        this.running_$eq(true);
    }

    private void unschedule() {
        block0: {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(20).append("Unscheduled ").append($this.serviceName).append(" service").toString());
            if (!this.scheduler().checkExists(this.trigger().getKey())) break block0;
            this.scheduler().unscheduleJob(this.trigger().getKey());
        }
    }

    @EventListener
    public void onStartup(SchedulerStartedEvent event) {
        block3: {
            try {
                if (this.notificationEnabled) {
                    this.schedule();
                    break block3;
                }
                this.unschedule();
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(29).append("Error while starting ").append($this.serviceName).append(" service").toString(), (Function0 & Serializable)() -> e);
            }
        }
    }

    public void enable() {
        this.resume();
    }

    public void disable() {
        this.pause();
    }

    public boolean isEnabled() {
        return this.running();
    }

    public String name() {
        return this.serviceName;
    }

    public BaseNotificationService(String serviceName, Class<? extends Job> jobClazz, Duration defaultTriggerInterval, boolean notificationEnabled) {
        this.serviceName = serviceName;
        this.jobClazz = jobClazz;
        this.defaultTriggerInterval = defaultTriggerInterval;
        this.notificationEnabled = notificationEnabled;
        ClassNameToString.$init$((ClassNameToString)this);
        Logging.$init$((Logging)this);
        this.running = false;
        this.jobName = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(new StringBuilder(4).append(serviceName).append(" JOB").toString().toUpperCase()), ' ')).mkString("_");
        this.groupName = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(serviceName.toUpperCase()), ' ')).mkString("_");
    }
}

