/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.quartz.release.scheduler;

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent;
import com.xebialabs.xlrelease.service.FeatureService;
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import scala.Function0;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Me!B\u000e\u001d\u0003\u0003I\u0003\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0005a\")1\u000f\u0001C\u0001i\"Aq\u0010\u0001a\u0001\n\u0013\t\t\u0001C\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!9\u0011\u0011\u0003\u0001!B\u0013\u0001\b\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011\u001d\t9\u0002\u0001Q\u0001\n\u001dC\u0011\"!\u0007\u0001\u0005\u0004%I!!\u0006\t\u000f\u0005m\u0001\u0001)A\u0005\u000f\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001BB\u000f\u0001\r\u0003\t\t\u0003\u0003\u0006\u0002*\u0001A)\u0019!C\u0001\u0003WA!\"a\r\u0001\u0011\u000b\u0007I\u0011AA\u001b\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0011\u0001\t\u0003\ty\u0004C\u0004\u0002D\u0001!I!a\u0010\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002@!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA8\u0001\u0011\u0005\u0013q\b\u0005\b\u0003c\u0002A\u0011IA \u0011\u001d\t\u0019\b\u0001C!\u0003kBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002|\u0001!\t%a\u0010\u0003/\t\u000b7/\u001a(pi&4\u0017nY1uS>t7+\u001a:wS\u000e,'BA\u000f\u001f\u0003%\u00198\r[3ek2,'O\u0003\u0002 A\u00059!/\u001a7fCN,'BA\u0011#\u0003\u0019\tX/\u0019:uu*\u00111\u0005J\u0001\nq2\u0014X\r\\3bg\u0016T!!\n\u0014\u0002\u0013a,'-[1mC\n\u001c(\"A\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001Q\u0003\u0007\u000f!\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0004d_6lwN\u001c\u0006\u0003k\t\nq!\u001e9he\u0006$W-\u0003\u00028e\t\t2\t\\1tg:\u000bW.\u001a+p'R\u0014\u0018N\\4\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014!B:mMRR'\"A\u001f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0010\u001e\u0003\u000f1{wmZ5oOB\u0011\u0011\tR\u0007\u0002\u0005*\u00111II\u0001\bg\u0016\u0014h/[2f\u0013\t)%I\u0001\bGK\u0006$XO]3TKJ4\u0018nY3\u0002\u0017M,'O^5dK:\u000bW.\u001a\t\u0003\u0011>s!!S'\u0011\u0005)cS\"A&\u000b\u00051C\u0013A\u0002\u001fs_>$h(\u0003\u0002OY\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tqE&\u0001\u0005k_\n\u001cE.\u0019>{a\t!\u0016\fE\u0002I+^K!AV)\u0003\u000b\rc\u0017m]:\u0011\u0005aKF\u0002\u0001\u0003\n5\n\t\t\u0011!A\u0003\u0002m\u00131a\u0018\u00132#\tav\f\u0005\u0002,;&\u0011a\f\f\u0002\b\u001d>$\b.\u001b8h!\t\u0001G-D\u0001b\u0015\t\t#MC\u0001d\u0003\ry'oZ\u0005\u0003K\u0006\u00141AS8c\u0003Y!WMZ1vYR$&/[4hKJLe\u000e^3sm\u0006d\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003!!WO]1uS>t'B\u00017-\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003]&\u0014\u0001\u0002R;sCRLwN\\\u0001\u0014]>$\u0018NZ5dCRLwN\\#oC\ndW\r\u001a\t\u0003WEL!A\u001d\u0017\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"R!^<y{z\u0004\"A\u001e\u0001\u000e\u0003qAQAR\u0003A\u0002\u001dCQAU\u0003A\u0002e\u0004$A\u001f?\u0011\u0007!+6\u0010\u0005\u0002Yy\u0012I!\f_A\u0001\u0002\u0003\u0015\ta\u0017\u0005\u0006M\u0016\u0001\ra\u001a\u0005\u0006_\u0016\u0001\r\u0001]\u0001\beVtg.\u001b8h+\u0005\u0001\u0018a\u0003:v]:LgnZ0%KF$B!a\u0002\u0002\u000eA\u00191&!\u0003\n\u0007\u0005-AF\u0001\u0003V]&$\b\u0002CA\b\u000f\u0005\u0005\t\u0019\u00019\u0002\u0007a$\u0013'\u0001\u0005sk:t\u0017N\\4!\u0003\u001dQwN\u0019(b[\u0016,\u0012aR\u0001\tU>\u0014g*Y7fA\u0005IqM]8va:\u000bW.Z\u0001\u000bOJ|W\u000f\u001d(b[\u0016\u0004\u0013a\u0004;sS\u001e<WM]%oi\u0016\u0014h/\u00197\u0016\u0003\u001d,\"!a\t\u0011\u0007\u0001\f)#C\u0002\u0002(\u0005\u0014\u0011bU2iK\u0012,H.\u001a:\u0002\u0007)|'-\u0006\u0002\u0002.A\u0019\u0001-a\f\n\u0007\u0005E\u0012MA\u0005K_\n$U\r^1jY\u00069AO]5hO\u0016\u0014XCAA\u001c!\r\u0001\u0017\u0011H\u0005\u0004\u0003w\t'!D*j[BdW\r\u0016:jO\u001e,'/\u0001\u0004sKN,X.\u001a\u000b\u0003\u0003\u000f\tQ\u0001]1vg\u0016\f\u0001b]2iK\u0012,H.Z\u0001\u000bk:\u001c8\r[3ek2,\u0017!C8o'R\f'\u000f^;q)\u0011\t9!a\u0013\t\u000f\u00055S\u00031\u0001\u0002P\u0005)QM^3oiB!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V\u0001\na!\u001a<f]R\u001c\u0018\u0002BA-\u0003'\u0012QcU2iK\u0012,H.\u001a:Ti\u0006\u0014H/\u001a3Fm\u0016tG\u000fK\u0002\u0016\u0003;\u0002B!a\u0018\u0002l5\u0011\u0011\u0011\r\u0006\u0005\u0003\u001b\n\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014aB2p]R,\u0007\u0010\u001e\u0006\u0004\u0003S\u0012\u0017aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u00055\u0014\u0011\r\u0002\u000e\u000bZ,g\u000e\u001e'jgR,g.\u001a:\u0002\r\u0015t\u0017M\u00197f\u0003\u001d!\u0017n]1cY\u0016\f\u0011\"[:F]\u0006\u0014G.\u001a3\u0015\u0003A\fAA\\1nKR\tq)\u0001\u0003ti>\u0004\bf\u0001\u0001\u0002\u0000A!\u0011\u0011QAH\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:TA!!#\u0002\f\u0006\u00191/\u001d7\u000b\u0007\u00055%%\u0001\u0002eE&!\u0011\u0011SAB\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public abstract class BaseNotificationService
implements ClassNameToString,
Logging,
FeatureService {
    private JobDetail job;
    private SimpleTrigger trigger;
    private final String serviceName;
    private Class<? extends Job> jobClazz;
    private final Duration defaultTriggerInterval;
    private final boolean notificationEnabled;
    private boolean running;
    private final String jobName;
    private final String groupName;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public String toString() {
        return ClassNameToString.toString$((ClassNameToString)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private String jobName() {
        return this.jobName;
    }

    private String groupName() {
        return this.groupName;
    }

    public Duration triggerInterval() {
        return this.defaultTriggerInterval;
    }

    public abstract Scheduler scheduler();

    private JobDetail job$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.job = JobBuilder.newJob(this.jobClazz).withDescription(new StringBuilder(4).append(this.serviceName).append(" job").toString()).withIdentity(this.jobName(), this.groupName()).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.jobClazz = null;
        return this.job;
    }

    public JobDetail job() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.job$lzycompute();
        }
        return this.job;
    }

    private SimpleTrigger trigger$lzycompute() {
        BaseNotificationService baseNotificationService = this;
        synchronized (baseNotificationService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(this.jobName(), this.groupName()).withDescription(new StringBuilder(13).append("Trigger ").append(this.serviceName).append(" jobs").toString()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.triggerInterval().toMillis()).repeatForever().withMisfireHandlingInstructionNowWithRemainingCount()).startNow().build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.trigger;
    }

    public SimpleTrigger trigger() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.trigger$lzycompute();
        }
        return this.trigger;
    }

    public void resume() {
        if (!this.running()) {
            this.scheduler().resumeJob(this.job().getKey());
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(16).append("Started ").append($this.serviceName).append(" service").toString());
        }
        this.running_$eq(true);
    }

    public void pause() {
        if (this.running()) {
            this.scheduler().pauseJob(this.job().getKey());
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(16).append("Stopped ").append($this.serviceName).append(" service").toString());
        }
        this.running_$eq(false);
    }

    private void schedule() {
        Date date;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Scheduled ").append($this.serviceName).append(" service").toString());
        if (this.scheduler().checkExists(this.trigger().getKey())) {
            date = this.scheduler().rescheduleJob(this.trigger().getKey(), (Trigger)this.trigger());
        } else {
            this.scheduler().scheduleJob(this.job(), CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleTrigger[]{this.trigger()}))).asJava(), true);
            date = BoxedUnit.UNIT;
        }
        this.running_$eq(true);
    }

    private void unschedule() {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(20).append("Unscheduled ").append($this.serviceName).append(" service").toString());
        if (this.scheduler().checkExists(this.trigger().getKey())) {
            this.scheduler().unscheduleJob(this.trigger().getKey());
            return;
        }
    }

    @EventListener
    public void onStartup(SchedulerStartedEvent event) {
        block3: {
            try {
                if (this.notificationEnabled) {
                    this.schedule();
                    break block3;
                }
                this.unschedule();
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(29).append("Error while starting ").append($this.serviceName).append(" service").toString(), (Function0 & Serializable)() -> e);
            }
        }
    }

    public void enable() {
        this.resume();
    }

    public void disable() {
        this.pause();
    }

    public boolean isEnabled() {
        return this.running();
    }

    public String name() {
        return this.serviceName;
    }

    public void stop() {
        this.running_$eq(false);
    }

    public BaseNotificationService(String serviceName, Class<? extends Job> jobClazz, Duration defaultTriggerInterval, boolean notificationEnabled) {
        this.serviceName = serviceName;
        this.jobClazz = jobClazz;
        this.defaultTriggerInterval = defaultTriggerInterval;
        this.notificationEnabled = notificationEnabled;
        ClassNameToString.$init$((ClassNameToString)this);
        Logging.$init$((Logging)this);
        this.running = false;
        this.jobName = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(new StringBuilder(4).append(serviceName).append(" JOB").toString().toUpperCase()), ' ')).mkString("_");
        this.groupName = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(serviceName.toUpperCase()), ' ')).mkString("_");
    }
}

