package com.xebialabs.xlrelease.quartz.release.scheduler

import com.xebialabs.xlrelease.domain.PlanItem
import com.xebialabs.xlrelease.quartz.release.scheduler.QuartzPendingPlanItemScheduledJobService.JOB_DATE_KEY
import org.quartz.{Job, JobExecutionContext}

trait PendingPlanItemQuartzJob[A <: PlanItem] extends Job {

  def supports(planItem: PlanItem): Boolean

  def getPlanItemIdFromJobData(context: JobExecutionContext): String = context.getJobDetail.getJobDataMap.getString(JOB_DATE_KEY)

}
